<?php
/**
 * Template Name: SoftWare
 */

get_header();
$url_num = '';
if(get_bloginfo('language')=='en-US'){
	$url_num = '-2';
}

?>
    <div class="header-page bg-blue container-fluid px-5 d-flex justify-content-center align-items-center font-weight-bold">
        <h1 class="font-weight-bold text-center"><?php pll_e('نرم‌افزارهای ورق‌کاری'); ?></h1>
        <img src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" style="background-image:url('<?php echo get_template_directory_uri(); ?>/inc/assets/img/software/slider-bg-3.jpg'); opacity: 0.2;">
    </div>
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
			<?php
			if(function_exists('bcn_display'))
			{
				bcn_display();
			}
			?>
        </ol>
    </nav>
    <div class="container mt-5">
        <div class="row" dir="rtl">
            <div class="col-lg-9" <?php if(!is_rtl()){ ?>dir="ltr"<?php } ?>>
                <?php
                while ( have_posts() ) : the_post();
                    get_template_part( 'template-parts/content', 'software' );
                endwhile; // End of the loop.
                ?>
            </div>
            <div class="col-lg-3 text-left">
                <a href="https://www.lanteksms.com/us/reseller-list" target="_blank">
                    <div class="card text-white bg-info my-0 rounded-0">
                        <div class="card-body">
                            <p class="card-text text-center"><?php pll_e('آیا می‌دانید راتین تجهیز البرز نماینده انحصاری لنتک در ایران است؟'); ?></p>
                        </div>
                    </div>
                    <img src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/software/lantek_premium_reseller.png" class="img-fluid img-thumbnail w-100 rounded-0 border-info border-top-0" alt="">
                </a>
                <hr>
                <div id="accordion" class="accordion" data-children=".list-group">
                    <div class="list-group">
                        <a href="<?php echo esc_url( home_url( '/' )); ?>lantek-expert<?php echo $url_num; ?>" class="list-group-item list-group-item-action">
                            <img class="float-left mt-1" style="width: 20px; height: 20px;" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/software/lantek_cadcam_software.png"><span class="mx-2">Lantek Expert</span>
                            <a data-toggle="collapse"
                               data-parent="#accordion"
                               href="#accordion1"
                               aria-expanded="true"
                               aria-controls="accordion1" class="position-absolute"></a>
                        </a>
                        <div id="accordion1" class="collapse show" role="tabpanel">
                            <a href="<?php echo esc_url( home_url( '/' )); ?>lantek-expert-cut-oxycut-plasma-laser-water-jet<?php echo $url_num; ?>" class="list-group-item list-group-item-action px-5">Cut</a>
                            <a href="<?php echo esc_url( home_url( '/' )); ?>lantek-expert-punch<?php echo $url_num; ?>" class="list-group-item list-group-item-action px-5">Punch</a>
                            <a href="<?php echo esc_url( home_url( '/' )); ?>lantek-expert-quattro<?php echo $url_num; ?>" class="list-group-item list-group-item-action px-5">Quattro</a>
                            <a href="<?php echo esc_url( home_url( '/' )); ?>lantek-expert-duct<?php echo $url_num; ?>" class="list-group-item list-group-item-action px-5">Duct</a>
                        </div>
                    </div>
                    <div class="list-group mt-3">
                        <a href="<?php echo esc_url( home_url( '/' )); ?>lantek-flex3d<?php echo $url_num; ?>" class="list-group-item list-group-item-action">
                            <img class="float-left mt-1" style="width: 20px; height: 20px;" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/software/f3-color.png"><span class="mx-2">Lantek Flex3d</span>
                            <a data-toggle="collapse"
                               data-parent="#accordion"
                               href="#accordion2"
                               aria-expanded="true"
                               aria-controls="accordion2" class="position-absolute"></a>
                        </a>
                        <div id="accordion2" class="collapse show" role="tabpane2">
                            <a href="<?php echo esc_url( home_url( '/' )); ?>lantek-flex3d-steelwork<?php echo $url_num; ?>" class="list-group-item list-group-item-action px-5">Steelwork</a>
                            <a href="<?php echo esc_url( home_url( '/' )); ?>lantek-flex3d-tubes<?php echo $url_num; ?>" class="list-group-item list-group-item-action px-5">Tubes</a>
                            <a href="<?php echo esc_url( home_url( '/' )); ?>lantek-flex3d-5x<?php echo $url_num; ?>" class="list-group-item list-group-item-action px-5">5x</a>
                            <a href="<?php echo esc_url( home_url( '/' )); ?>lantek-flex3d-addins<?php echo $url_num; ?>" class="list-group-item list-group-item-action px-5">CAD Addins</a>
                            <a href="<?php echo esc_url( home_url( '/' )); ?>lantek-flex3d-unfolding<?php echo $url_num; ?>" class="list-group-item list-group-item-action px-5">Unfolding</a>
                        </div>
                    </div>
                    <div class="list-group mt-3">
                        <a href="<?php echo esc_url( home_url( '/' )); ?>lantek-workshop<?php echo $url_num; ?>" class="list-group-item list-group-item-action">
                            <img class="float-left mt-1" style="width: 20px; height: 20px;" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/software/ws-color.png"><span class="mx-2">Lantek Workshop</span>
                            <a data-toggle="collapse"
                               data-parent="#accordion"
                               href="#accordion3"
                               aria-expanded="true"
                               aria-controls="accordion3" class="position-absolute"></a>
                        </a>
                        <div id="accordion3" class="collapse show" role="tabpane3">
                            <a href="<?php echo esc_url( home_url( '/' )); ?>lantek-manager<?php echo $url_num; ?>" class="list-group-item list-group-item-action px-5">Manager</a>
                            <a href="<?php echo esc_url( home_url( '/' )); ?>lantek-wos<?php echo $url_num; ?>" class="list-group-item list-group-item-action px-5">Wos</a>
                            <a href="<?php echo esc_url( home_url( '/' )); ?>lantek-workshop-capture<?php echo $url_num; ?>" class="list-group-item list-group-item-action px-5">Capture</a>
                        </div>
                    </div>
                    <div class="list-group mt-3">
                        <a href="<?php echo esc_url( home_url( '/' )); ?>lantek-integra<?php echo $url_num; ?>" class="list-group-item list-group-item-action">
                            <img class="float-left mt-1" style="width: 20px; height: 20px;" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/software/in-color.png"><span class="mx-2">Lantek Integra</span>
                            <a data-toggle="collapse"
                               data-parent="#accordion"
                               href="#accordion4"
                               aria-expanded="true"
                               aria-controls="accordion4" class="position-absolute"></a>
                        </a>
                        <div id="accordion4" class="collapse show" role="tabpane4">
                            <a href="<?php echo esc_url( home_url( '/' )); ?>lantek-integra-manufacturing<?php echo $url_num; ?>" class="list-group-item list-group-item-action px-5">Manufacturing</a>
                            <a href="<?php echo esc_url( home_url( '/' )); ?>lantek-integra-crm<?php echo $url_num; ?>" class="list-group-item list-group-item-action px-5">CRM</a>
                            <a href="<?php echo esc_url( home_url( '/' )); ?>lantek-integra-inventory<?php echo $url_num; ?>" class="list-group-item list-group-item-action px-5">Inventory</a>
                            <a href="<?php echo esc_url( home_url( '/' )); ?>lantek-integra-sales<?php echo $url_num; ?>" class="list-group-item list-group-item-action px-5">Sales</a>
                            <a href="<?php echo esc_url( home_url( '/' )); ?>lantek-integra-purchases<?php echo $url_num; ?>" class="list-group-item list-group-item-action px-5">Purchases</a>
                            <a href="<?php echo esc_url( home_url( '/' )); ?>lantek-integra-products<?php echo $url_num; ?>" class="list-group-item list-group-item-action px-5">Products</a>
                            <a href="<?php echo esc_url( home_url( '/' )); ?>lantek-integra-banking<?php echo $url_num; ?>" class="list-group-item list-group-item-action px-5">Banking</a>
                        </div>
                    </div>
                    <div class="list-group mt-3">
                        <a href="<?php echo esc_url( home_url( '/' )); ?>replica<?php echo $url_num; ?>" class="list-group-item list-group-item-action">
                            Integration Mechanisms (REPLICA)
                            <a data-toggle="collapse"
                               data-parent="#accordion"
                               href="#accordion5"
                               aria-expanded="true"
                               aria-controls="accordion5" class="position-absolute"></a>
                        </a>
                        <div id="accordion5" class="collapse show" role="tabpane5">
                            <a href="<?php echo esc_url( home_url( '/' )); ?>avantiaservices<?php echo $url_num; ?>" class="list-group-item list-group-item-action px-5">Avantiaservices</a>
                            <a href="<?php echo esc_url( home_url( '/' )); ?>powersync<?php echo $url_num; ?>" class="list-group-item list-group-item-action px-5">Powersync</a>
                            <a href="<?php echo esc_url( home_url( '/' )); ?>masterlink<?php echo $url_num; ?>" class="list-group-item list-group-item-action px-5">Masterlink</a>
                            <a href="<?php echo esc_url( home_url( '/' )); ?>bim-connector<?php echo $url_num; ?>" class="list-group-item list-group-item-action px-5">BIM Connector</a>
                            <a href="<?php echo esc_url( home_url( '/' )); ?>Opentalk<?php echo $url_num; ?>" class="list-group-item list-group-item-action px-5">Opentalk</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php if(get_the_ID()=='527' || get_the_ID()=='240') { ?>
        <div class="my-5 py-5"></div>
        <div class="container">
            <div class="row title mb-2">
                <div class="col-sm-12 pt-5 header">
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="animation-slide-up">
                                <h1 class="text-center font-weight-bold"><?php pll_e('درباره‌ لنتک'); ?></h1>
                            </div>
                            <i class="fa fa-commenting position-absolute bg bg-center" aria-hidden="true" style="top:-200px;"></i>
                        </div>
                        <div class="col-md-6 offset-md-3 col-sm-8 offset-sm-2 col-12 offset-0 position-relative">
                            <div class="d-flex flex-row justify-content-center align-items-center">
                                <hr style="width: 45%;">
                                <i class="fa fa-angle-double-down fa-2x text-center angle" aria-hidden="true"></i>
                                <hr style="width: 45%;">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row mx-auto">
                <div class="col-sm-12">
                    <p><?php pll_e('لنتک یک شرکت جهانی با رویکرد محلی می باشد. لنتک می خواهد نزدیک مشتریان و شرکای خود بوده، نیازهای آنها را بدون واسطه بشناسد و با داشتن یک رابطه نزدیک و دست در دست آنها برای یافتن بهترین راه حل به منظور بهبود بهره وری و کارآمدی آنها اقدام نماید.'); ?></p>
                </div>
                <div class="col-lg-4">
                    <p class="text-center">
                        <img class="img-fluid" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/software/solutions-by-sector.png">
                    </p>
                    <p><?php pll_e('لنتک بهترین مشورت ممکن، گسترده ترین طیف محصولات و بهترین تیم متخصصان را ارائه می کند که آماده ی رویارویی با هر سناریویی در زمینه ماشین در بخش شیت متال و ساختارهای استیل می باشند.'); ?></p>
                </div>
                <div class="col-lg-4">
                    <p class="text-center">
                        <img class="img-fluid" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/software/solutions-by-manufacturing-model.png">
                    </p>
                    <p><?php pll_e('لنتک قادر است تا یک راه حل نرم افزاری کامل را صرف نظر از بخشی که شرکت شما به آن تعلق دارد، برای تولید فلزتان ارائه دهد.'); ?></p>
                </div>
                <div class="col-lg-4">
                    <p class="text-center">
                        <img class="img-fluid" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/software/solutions-by-technology.png">
                    </p>
                    <p><?php pll_e('لنتک به صورت موثر با تمامی ماشین آلات موجود شیت متال، تیوب یا اشعه همکاری نموده و به بیشترین بازدهی و عملکرد دست می یابد.'); ?></p>
                </div>
            </div>
        </div>
    <?php } ?>
    <div class="my-3 py-3"></div>
<?php
get_footer();
