<?php
/**
 * Template Name: Shears
 */

get_header(); ?>
    <div class="header-page full bg-blue container-fluid d-flex flex-column justify-content-center align-items-center">
        <h1 class="font-weight-bold text-center"><?php pll_e('گیوتین'); ?></h1>
        <h4 class="font-weight-light text-center"><i class="fa fa-quote-right" aria-hidden="true"></i> <?php pll_e('محصولات متنوع گیوتین برای گستره ی وسیعی از ضخامت ها و اندازه های ورق که تمامی نیازهای برش را برطرف می کنند. گیوتین های برش آونگی و برش عمودی، تک منظوره یا ترکیبی با حالت اتوماتیک برای بهبود عملکرد. محصولات به صورت زیر است: خط SM چند منظوره استاندارد، محصول GH Swing Cut همه کاره، GV برش عمودی با اندازه بزرگ'); ?> <i class="fa fa-quote-left" aria-hidden="true"></i></h4>
        <img src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" style="background-image:url('<?php echo get_template_directory_uri(); ?>/inc/assets/img/Shears.jpg');">
    </div>
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
			<?php
			if(function_exists('bcn_display'))
			{
				bcn_display();
			}
			?>
        </ol>
    </nav>
    <div class="product container mt-5">
        <div class="row title">
            <div class="col-sm-12 mb-2">
                <div class="animation-slide-up">
                    <h3 class="text-left text-blue font-weight-bold mb-0"><?php pll_e('SM Guimadira'); ?></h3>
                </div>
                <div class="clearfix">
                    <hr class="w-25 float-left">
                    <i class="fa fa-angle-double-right fa-2x float-left" aria-hidden="true"></i>
                </div>
            </div>
        </div>
        <div class="row mb-5" dir="rtl">
            <div class="col-lg-6 px-5 py-4 py-lg-0" <?php if(is_rtl()){ ?>dir="rtl"<?php } else { ?>dir="ltr"<?php } ?>>
                <div id="LE-Efficiency-carousel" class="navbar-change carousel slide" data-ride="carousel" data-interval="3000" data-pause="hover">
                    <ol class="carousel-indicators">
                        <li data-target="#LE-Efficiency-carousel" data-slide-to="0" class="active"></li>
                        <li data-target="#LE-Efficiency-carousel" data-slide-to="1"></li>
                        <li data-target="#LE-Efficiency-carousel" data-slide-to="2"></li>
                        <li data-target="#LE-Efficiency-carousel" data-slide-to="3"></li>
                        <li data-target="#LE-Efficiency-carousel" data-slide-to="4"></li>
                        <li data-target="#LE-Efficiency-carousel" data-slide-to="5"></li>
                    </ol>
                    <div class="carousel-inner">
                        <div class="carousel-item active">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/SM_Guimadira/UplImg_35_37_27.jpg" alt="SM Guimadira">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/SM_Guimadira/UplImg_35_37_393.jpg" alt="SM Guimadira">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/SM_Guimadira/UplImg_35_37_394.jpg" alt="SM Guimadira">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/SM_Guimadira/UplImg_35_37_395.jpg" alt="SM Guimadira">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/SM_Guimadira/UplImg_35_37_396.jpg" alt="SM Guimadira">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/SM_Guimadira/UplImg_35_37_397.jpg" alt="SM Guimadira">
                        </div>
                    </div>
                    <a class="carousel-control-prev" href="#LE-Efficiency-carousel" role="button" data-slide="prev">
                        <i class="fa fa-angle-<?php if(is_rtl()){ ?>right<?php } else { ?>left<?php } ?> fa-3x" aria-hidden="true"></i>
                        <span class="sr-only">Previous</span>
                    </a>
                    <a class="carousel-control-next" href="#LE-Efficiency-carousel" role="button" data-slide="next">
                        <i class="fa fa-angle-<?php if(is_rtl()){ ?>left<?php } else { ?>right<?php } ?> fa-3x" aria-hidden="true"></i>
                        <span class="sr-only">Next</span>
                    </a>
                </div>
            </div>
            <div class="col-lg-6 px-5" <?php if(is_rtl()){ ?>dir="rtl"<?php } else { ?>dir="ltr"<?php } ?>>
                <ul class="list-simple pt-3 pb-2">
                    <li class="font-weight-bold"><?php pll_e('بهترین نسبت قیمت به کیفیت'); ?></li>
                    <li><?php pll_e('2 مدل: 6mm یا 13mm با 3 متر طول'); ?></li>
                    <li><?php pll_e('Swing Cut'); ?></li>
                    <li><?php pll_e('به صورت دلخواه با سیستم پشتیبانی ورق نازک'); ?></li>
                    <li><?php pll_e('سهولت استفاده'); ?></li>
                    <li><?php pll_e('راه حل اثبات شده'); ?></li>
                    <li><?php pll_e('طراحی و تولید شده در اروپا'); ?></li>
                    <li><?php pll_e('استانداردهای کیفی بالا'); ?></li>
                    <li><?php pll_e('قیمت رقابتی'); ?></li>
                </ul>
                <p class="text-center">
                    <a href="http://www.adira.pt/clidocs/Gr38_125_0.pdf" class="btn btn-primary btn-special"><i class="fa fa-download" aria-hidden="true"></i> <?php pll_e('دانلود کاتالوگ'); ?></a>
                </p>
            </div>
        </div>
        <div class="my-5 py-5"></div>
        <div class="row title">
            <div class="col-sm-12 mb-2">
                <div class="animation-slide-up">
                    <h3 class="text-right text-blue font-weight-bold mb-0"><?php pll_e('GH همه کاره'); ?></h3>
                </div>
                <div class="clearfix">
                    <hr class="w-25 float-right">
                    <i class="fa fa-angle-double-left fa-2x float-right" aria-hidden="true"></i>
                </div>
            </div>
        </div>
        <div class="row mb-5" dir="rtl">
            <div class="col-lg-6 px-5" <?php if(is_rtl()){ ?>dir="rtl"<?php } else { ?>dir="ltr"<?php } ?>>
                <ul class="list-simple pt-3 pb-2">
                    <li class="font-weight-bold"><?php pll_e('گستره ی وسیعی از پیکربندی ها'); ?></li>
                    <li><?php pll_e('ضخامت و اندازه های چندگانه'); ?></li>
                    <li><?php pll_e('Swing Cut'); ?></li>
                    <li><?php pll_e('زاویه ثابت کوچک برای پوشش تمام ضخامت ها'); ?></li>
                    <li><?php pll_e('استحکام و قابلیت اطمینان'); ?> </li>
                    <li><?php pll_e('ثبت اختراع SCSC، سیستم پشتیبانی ورق ترکیبی'); ?></li>
                    <li><?php pll_e('تجربه ی اثبات شده'); ?></li>
                    <li><?php pll_e('طیف وسیعی از انتخاب ها'); ?></li>
                </ul>
                <p class="text-center">
                    <a href="http://www.adira.pt/clidocs/Gr38_90_0.pdf" class="btn btn-primary btn-special"><i class="fa fa-download" aria-hidden="true"></i> <?php pll_e('دانلود کاتالوگ'); ?></a>
                </p>
            </div>
            <div class="col-lg-6 px-5 py-4 py-lg-0" <?php if(is_rtl()){ ?>dir="rtl"<?php } else { ?>dir="ltr"<?php } ?>>
                <div id="GH-Versatile-carousel" class="navbar-change carousel slide" data-ride="carousel" data-interval="3000" data-pause="hover">
                    <ol class="carousel-indicators">
                        <li data-target="#GH-Versatile-carousel" data-slide-to="0" class="active"></li>
                        <li data-target="#GH-Versatile-carousel" data-slide-to="1"></li>
                        <li data-target="#GH-Versatile-carousel" data-slide-to="2"></li>
                        <li data-target="#GH-Versatile-carousel" data-slide-to="3"></li>
                        <li data-target="#GH-Versatile-carousel" data-slide-to="4"></li>
                    </ol>
                    <div class="carousel-inner">
                        <div class="carousel-item active">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/GH_Versatile/UplImg_35_38_19.jpg" alt="GH Versatile">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/GH_Versatile/UplImg_35_38_20.jpg" alt="GH Versatile">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/GH_Versatile/UplImg_35_38_21.jpg" alt="GH Versatile">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/GH_Versatile/UplImg_35_38_22.jpg" alt="GH Versatile">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/GH_Versatile/UplImg_35_38_416.jpg" alt="GH Versatile">
                        </div>
                    </div>
                    <a class="carousel-control-prev" href="#GH-Versatile-carousel" role="button" data-slide="prev">
                        <i class="fa fa-angle-<?php if(is_rtl()){ ?>right<?php } else { ?>left<?php } ?> fa-3x" aria-hidden="true"></i>
                        <span class="sr-only">Previous</span>
                    </a>
                    <a class="carousel-control-next" href="#GH-Versatile-carousel" role="button" data-slide="next">
                        <i class="fa fa-angle-<?php if(is_rtl()){ ?>left<?php } else { ?>right<?php } ?> fa-3x" aria-hidden="true"></i>
                        <span class="sr-only">Next</span>
                    </a>
                </div>
            </div>
        </div>
        <div class="my-5 py-5"></div>
        <div class="row title">
            <div class="col-sm-12 mb-2">
                <div class="animation-slide-up">
                    <h3 class="text-left text-blue font-weight-bold mb-0"><?php pll_e('GV مخصوص کارهای سنگین'); ?></h3>
                </div>
                <div class="clearfix">
                    <hr class="w-25 float-left">
                    <i class="fa fa-angle-double-right fa-2x float-left" aria-hidden="true"></i>
                </div>
            </div>
        </div>
        <div class="row mb-5" dir="rtl">
            <div class="col-lg-6 px-5 py-4 py-lg-0" <?php if(is_rtl()){ ?>dir="rtl"<?php } else { ?>dir="ltr"<?php } ?>>
                <div id="GV-Heavy-Duty-carousel" class="navbar-change carousel slide" data-ride="carousel" data-interval="3000" data-pause="hover">
                    <ol class="carousel-indicators">
                        <li data-target="#GV-Heavy-Duty-carousel" data-slide-to="0" class="active"></li>
                        <li data-target="#GV-Heavy-Duty-carousel" data-slide-to="1"></li>
                        <li data-target="#GV-Heavy-Duty-carousel" data-slide-to="2"></li>
                        <li data-target="#GV-Heavy-Duty-carousel" data-slide-to="3"></li>
                    </ol>
                    <div class="carousel-inner">
                        <div class="carousel-item active">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/GV_Heavy_Duty/UplImg_35_39_23.jpg" alt="GV Heavy Duty">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/GV_Heavy_Duty/UplImg_35_39_24.jpg" alt="GV Heavy Duty">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/GV_Heavy_Duty/UplImg_35_39_25.jpg" alt="GV Heavy Duty">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/GV_Heavy_Duty/UplImg_35_39_26.jpg" alt="GV Heavy Duty">
                        </div>
                    </div>
                    <a class="carousel-control-prev" href="#GV-Heavy-Duty-carousel" role="button" data-slide="prev">
                        <i class="fa fa-angle-<?php if(is_rtl()){ ?>right<?php } else { ?>left<?php } ?> fa-3x" aria-hidden="true"></i>
                        <span class="sr-only">Previous</span>
                    </a>
                    <a class="carousel-control-next" href="#GV-Heavy-Duty-carousel" role="button" data-slide="next">
                        <i class="fa fa-angle-<?php if(is_rtl()){ ?>left<?php } else { ?>right<?php } ?> fa-3x" aria-hidden="true"></i>
                        <span class="sr-only">Next</span>
                    </a>
                </div>
            </div>
            <div class="col-lg-6 px-5" <?php if(is_rtl()){ ?>dir="rtl"<?php } else { ?>dir="ltr"<?php } ?>>
                <ul class="list-simple py-5">
                    <li><?php pll_e('گیوتینی برای ابعاد بزرگ'); ?></li>
                    <li><?php pll_e('ضخامت برش حداکثر تا 25mm، در صورت نیاز گزینه های سفارشی بیشتری وجود داردمصرف الکتریکی پایین'); ?></li>
                    <li><?php pll_e('اندازه حداکثر تا 6 متر، در صورت نیاز گزینه های سفارشی بیشتری وجود دارد'); ?> </li>
                    <li><?php pll_e('برش عمودی'); ?></li>
                    <li><?php pll_e('سیستم ضد پیچش انتخابی'); ?></li>
                    <li><?php pll_e('استحکام، قابلیت اطمینان، ایمنی'); ?></li>
                    <li><?php pll_e('انتخاب ایده آل برای وظایف سنگین'); ?></li>
                </ul>
                <p class="text-center">
                    <a href="http://www.adira.pt/clidocs/Gr38_87_0.pdf" class="btn btn-primary btn-special"><i class="fa fa-download" aria-hidden="true"></i> <?php pll_e('دانلود کاتالوگ'); ?></a>
                </p>
            </div>
        </div>
        <div class="my-5 py-5"></div>
    </div>
<?php
get_footer();
