<?php
/**
 * Template Name: Laser
 */

get_header(); ?>
    <div class="header-page full bg-blue container-fluid p-2 p-sm-5 d-flex flex-column justify-content-center align-items-center">
        <h1 class="font-weight-bold text-center"><?php pll_e('لیزر'); ?></h1>
        <h4 class="font-weight-light text-center"><i class="fa fa-quote-right" aria-hidden="true"></i> <?php pll_e('بیش از 10 سال است که Adira ماشین های برش لیزر را با موفقیت تولید می کند. این محصولات شامل موارد زیر می باشد: ماشین LE سطح استاندارد برای گستره ی وسیعی از کاربردها، ماشین LP کلاسیک با موتورهای خطی و عملکرد بالا در تمامی موقعیت ها، ماشین LF با یک لیزر فایبر نوین که به صورت ایده آل برای صفحات نازک و مواد صیقلی با مصرف و تعمیر و نگهداری پایین طراحی شده است. تمام ماشین های لیزر Adira، قابلیت اطمینان، دقت و عملکرد بالا را در برش فلز ارائه می دهند.'); ?> <i class="fa fa-quote-left" aria-hidden="true"></i></h4>
        <img src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" style="background-image:url('<?php echo get_template_directory_uri(); ?>/inc/assets/img/Laser.jpg'); opacity: 0.25;">
    </div>
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
			<?php
			if(function_exists('bcn_display'))
			{
				bcn_display();
			}
			?>
        </ol>
    </nav>
    <div class="product container mt-5">
        <div class="row title">
            <div class="col-sm-12 mb-2">
                <div class="animation-slide-up">
                    <h3 class="text-left text-blue font-weight-bold mb-0"><?php pll_e('LE کارآمد'); ?></h3>
                </div>
                <div class="clearfix">
                    <hr class="w-25 float-left">
                    <i class="fa fa-angle-double-right fa-2x float-left" aria-hidden="true"></i>
                </div>
            </div>
        </div>
        <div class="row mb-5" dir="rtl">
            <div class="col-lg-6 px-5 py-4 py-lg-0" <?php if(is_rtl()){ ?>dir="rtl"<?php } else { ?>dir="ltr"<?php } ?>>
                <div id="LE-Efficiency-carousel" class="navbar-change carousel slide" data-ride="carousel" data-interval="3000" data-pause="hover">
                    <ol class="carousel-indicators">
                        <li data-target="#LE-Efficiency-carousel" data-slide-to="0" class="active"></li>
                        <li data-target="#LE-Efficiency-carousel" data-slide-to="1"></li>
                        <li data-target="#LE-Efficiency-carousel" data-slide-to="2"></li>
                        <li data-target="#LE-Efficiency-carousel" data-slide-to="3"></li>
                        <li data-target="#LE-Efficiency-carousel" data-slide-to="4"></li>
                        <li data-target="#LE-Efficiency-carousel" data-slide-to="5"></li>
                        <li data-target="#LE-Efficiency-carousel" data-slide-to="6"></li>
                        <li data-target="#LE-Efficiency-carousel" data-slide-to="7"></li>
                    </ol>
                    <div class="carousel-inner">
                        <div class="carousel-item active">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/LE_Efficiency/UplImg_35_33_209.jpg" alt="<?php pll_e('LE کارآمد'); ?>">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/LE_Efficiency/UplImg_35_33_210.jpg" alt="<?php pll_e('LE کارآمد'); ?>">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/LE_Efficiency/UplImg_35_33_211.jpg" alt="<?php pll_e('LE کارآمد'); ?>">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/LE_Efficiency/UplImg_35_33_212.jpg" alt="<?php pll_e('LE کارآمد'); ?>">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/LE_Efficiency/UplImg_35_33_213.jpg" alt="<?php pll_e('LE کارآمد'); ?>">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/LE_Efficiency/UplImg_35_33_214.jpg" alt="<?php pll_e('LE کارآمد'); ?>">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/LE_Efficiency/UplImg_35_33_215.jpg" alt="<?php pll_e('LE کارآمد'); ?>">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/LE_Efficiency/UplImg_35_33_216.jpg" alt="<?php pll_e('LE کارآمد'); ?>">
                        </div>
                    </div>
                    <a class="carousel-control-prev" href="#LE-Efficiency-carousel" role="button" data-slide="prev">
                        <i class="fa fa-angle-<?php if(is_rtl()){ ?>right<?php } else { ?>left<?php } ?> fa-3x" aria-hidden="true"></i>
                        <span class="sr-only">Previous</span>
                    </a>
                    <a class="carousel-control-next" href="#LE-Efficiency-carousel" role="button" data-slide="next">
                        <i class="fa fa-angle-<?php if(is_rtl()){ ?>left<?php } else { ?>right<?php } ?> fa-3x" aria-hidden="true"></i>
                        <span class="sr-only">Next</span>
                    </a>
                </div>
            </div>
            <div class="col-lg-6 px-5" <?php if(is_rtl()){ ?>dir="rtl"<?php } else { ?>dir="ltr"<?php } ?>>
                <ul class="list-simple pt-3 pb-2">
                    <li> <?php pll_e('سطح استاندارد برش لیزر'); ?> </li>
                    <li> <?php pll_e('سیستم حرکت rack & pinion به شدت دقیق'); ?> </li>
                    <li> <?php pll_e('عرض 3 متری گانتری با میز برش قابل گسترش'); ?></li>
                    <li> <?php pll_e('پیکربندی انعطاف پذیر'); ?></li>
                    <li> <?php pll_e('بهترین کیفیت، تطبیق پذیری و نسبت قیمت'); ?></li>
                    <li> <?php pll_e('قیمت رقابتی'); ?> </li>
                </ul>
                <p class="text-center">
                    <a href="http://www.adira.pt/clidocs/Gr38_28_0.pdf" target="_blank" class="btn btn-primary btn-special btn-special"><i class="fa fa-download" aria-hidden="true"></i> <?php pll_e('دانلود کاتالوگ'); ?></a>
                </p>
            </div>
        </div>
        <div class="my-5 py-5"></div>
        <div class="row title">
            <div class="col-sm-12 mb-2">
                <div class="animation-slide-up">
                    <h3 class="text-right text-blue font-weight-bold mb-0"><?php pll_e('LP فوق العاده'); ?></h3>
                </div>
                <div class="clearfix">
                    <hr class="w-25 float-right">
                    <i class="fa fa-angle-double-left fa-2x float-right" aria-hidden="true"></i>
                </div>
            </div>
        </div>
        <div class="row mb-5" dir="rtl">
            <div class="col-lg-6 px-5" <?php if(is_rtl()){ ?>dir="rtl"<?php } else { ?>dir="ltr"<?php } ?>>
                <ul class="list-simple pt-3 pb-2">
                    <li> <?php pll_e('یک لیزر CO2 نوع SLAB با تعمیر و نگهداری پایین'); ?> </li>
                    <li> <?php pll_e('سرعت جابه جایی بالا به دلیل موتور linear'); ?> </li>
                    <li> <?php pll_e('بهره وری بالا'); ?> </li>
                    <li> <?php pll_e('کارایی برتر سورس لیزر: لیزر SLAB 2.5KW ورق کربن استیل تا 20mm را برش می دهد'); ?> </li>
                    <li> <?php pll_e('قطعات عالی: موتورهای خطی و سورس لیزر کیفیت بالا'); ?> </li>
                    <li> <?php pll_e('ترکیب ایده آل بهره وری بالا و تطبیق پذیری'); ?></li>
                </ul>
                <p class="text-center">
                    <a href="http://www.adira.pt/clidocs/Gr38_116_0.pdf" class="btn btn-primary btn-special"><i class="fa fa-download" aria-hidden="true"></i> <?php pll_e('دانلود کاتالوگ'); ?></a>
                </p>
            </div>
            <div class="col-lg-6 px-5 py-4 py-lg-0" <?php if(is_rtl()){ ?>dir="rtl"<?php } else { ?>dir="ltr"<?php } ?>>
                <div id="LP-Premium-carousel" class="navbar-change carousel slide" data-ride="carousel" data-interval="3000" data-pause="hover">
                    <ol class="carousel-indicators">
                        <li data-target="#LP-Premium-carousel" data-slide-to="0" class="active"></li>
                        <li data-target="#LP-Premium-carousel" data-slide-to="1"></li>
                        <li data-target="#LP-Premium-carousel" data-slide-to="2"></li>
                        <li data-target="#LP-Premium-carousel" data-slide-to="3"></li>
                        <li data-target="#LP-Premium-carousel" data-slide-to="4"></li>
                        <li data-target="#LP-Premium-carousel" data-slide-to="5"></li>
                    </ol>
                    <div class="carousel-inner">
                        <div class="carousel-item active">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/LP_Premium/UplImg_35_34_38.jpg" alt="<?php pll_e('LP فوق العاده'); ?>">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/LP_Premium/UplImg_35_34_39.jpg" alt="<?php pll_e('LP فوق العاده'); ?>">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/LP_Premium/UplImg_35_34_250.jpg" alt="<?php pll_e('LP فوق العاده'); ?>">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/LP_Premium/UplImg_35_34_251.jpg" alt="<?php pll_e('LP فوق العاده'); ?>">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/LP_Premium/UplImg_35_34_252.jpg" alt="<?php pll_e('LP فوق العاده'); ?>">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/LP_Premium/UplImg_35_34_253.jpg" alt="<?php pll_e('LP فوق العاده'); ?>">
                        </div>
                    </div>
                    <a class="carousel-control-prev" href="#LP-Premium-carousel" role="button" data-slide="prev">
                        <i class="fa fa-angle-<?php if(is_rtl()){ ?>right<?php } else { ?>left<?php } ?> fa-3x" aria-hidden="true"></i>
                        <span class="sr-only">Previous</span>
                    </a>
                    <a class="carousel-control-next" href="#LP-Premium-carousel" role="button" data-slide="next">
                        <i class="fa fa-angle-<?php if(is_rtl()){ ?>left<?php } else { ?>right<?php } ?> fa-3x" aria-hidden="true"></i>
                        <span class="sr-only">Next</span>
                    </a>
                </div>
            </div>
        </div>
        <div class="my-5 py-5"></div>
        <div class="row title">
            <div class="col-sm-12 mb-2">
                <div class="animation-slide-up">
                    <h3 class="text-left text-blue font-weight-bold mb-0"><?php pll_e('LF فایبر'); ?></h3>
                </div>
                <div class="clearfix">
                    <hr class="w-25 float-left">
                    <i class="fa fa-angle-double-right fa-2x float-left" aria-hidden="true"></i>
                </div>
            </div>
        </div>
        <div class="row mb-5" dir="rtl">
            <div class="col-lg-6 px-5 py-4 py-lg-0" <?php if(is_rtl()){ ?>dir="rtl"<?php } else { ?>dir="ltr"<?php } ?>>
                <div id="LF-Fiber-carousel" class="navbar-change carousel slide" data-ride="carousel" data-interval="3000" data-pause="hover">
                    <ol class="carousel-indicators">
                        <li data-target="#LF-Fiber-carousel" data-slide-to="0" class="active"></li>
                        <li data-target="#LF-Fiber-carousel" data-slide-to="1"></li>
                        <li data-target="#LF-Fiber-carousel" data-slide-to="2"></li>
                        <li data-target="#LF-Fiber-carousel" data-slide-to="3"></li>
                        <li data-target="#LF-Fiber-carousel" data-slide-to="4"></li>
                    </ol>
                    <div class="carousel-inner">
                        <div class="carousel-item active">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/LF_Fiber/UplImg_35_35_33.jpg" alt="<?php pll_e('LF فایبر'); ?>">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/LF_Fiber/UplImg_35_35_35.jpg" alt="<?php pll_e('LF فایبر'); ?>">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/LF_Fiber/UplImg_35_35_134.jpg" alt="<?php pll_e('LF فایبر'); ?>">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/LF_Fiber/UplImg_35_35_135.jpg" alt="<?php pll_e('LF فایبر'); ?>">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/LF_Fiber/UplImg_35_35_136.jpg" alt="<?php pll_e('LF فایبر'); ?>">
                        </div>
                    </div>
                    <a class="carousel-control-prev" href="#LF-Fiber-carousel" role="button" data-slide="prev">
                        <i class="fa fa-angle-<?php if(is_rtl()){ ?>right<?php } else { ?>left<?php } ?> fa-3x" aria-hidden="true"></i>
                        <span class="sr-only">Previous</span>
                    </a>
                    <a class="carousel-control-next" href="#LF-Fiber-carousel" role="button" data-slide="next">
                        <i class="fa fa-angle-<?php if(is_rtl()){ ?>left<?php } else { ?>right<?php } ?> fa-3x" aria-hidden="true"></i>
                        <span class="sr-only">Next</span>
                    </a>
                </div>
            </div>
            <div class="col-lg-6 px-5" <?php if(is_rtl()){ ?>dir="rtl"<?php } else { ?>dir="ltr"<?php } ?>>
                <ul class="list-simple py-5">
                    <li> <?php pll_e('لیزر فایبر، برتری تکنولوژی در سطح جهانی'); ?> </li>
                    <li> <?php pll_e('مصرف الکتریکی پایین'); ?> </li>
                    <li> <?php pll_e('تعمیر و نگهداری کم (سورس لیزر بدون نیاز به نگهداری، موتور خطی با نگهداری پایین و لنز محافظت شده با شیشه)'); ?> </li>
                    <li> <?php pll_e('مصرف گاز پایین (سورس لیزر به گاز نیاز ندارد)'); ?> </li>
                    <li> <?php pll_e('تکنولوژی بهینه برای برش مواد صیقلی'); ?> </li>
                    <li> <?php pll_e('انتخاب ایده آل برای صغحات نازک'); ?> </li>
                    <li> <?php pll_e('سرعت جابه جایی بالا توسط موتورهای خطی'); ?> </li>
                    <li> <?php pll_e('سرعت برش غیر قابل رقابت'); ?> </li>
                </ul>
                <p class="text-center">
                    <a href="http://www.adira.pt/clidocs/Gr38_117_0.pdf" class="btn btn-primary btn-special"><i class="fa fa-download" aria-hidden="true"></i> <?php pll_e('دانلود کاتالوگ'); ?></a>
                </p>
            </div>
        </div>
        <div class="my-5 py-5"></div>
        <div class="row title">
            <div class="col-sm-12 mb-2">
                <div class="animation-slide-up">
                    <h3 class="text-right text-blue font-weight-bold mb-0"><?php pll_e('Blue Laser'); ?></h3>
                </div>
                <div class="clearfix">
                    <hr class="w-25 float-right">
                    <i class="fa fa-angle-double-left fa-2x float-right" aria-hidden="true"></i>
                </div>
            </div>
        </div>
        <div class="row mb-5" dir="rtl">
            <div class="col-lg-6 px-5" <?php if(is_rtl()){ ?>dir="rtl"<?php } else { ?>dir="ltr"<?php } ?>>
                <ul class="list-simple pt-3 pb-2">
                    <li> <?php pll_e('سیستم حرکت rack & pinion به شدت دقیق'); ?> </li>
                    <li> <?php pll_e('مصرف الکتریکی پایین'); ?> </li>
                    <li> <?php pll_e('مصرف گاز پایین، تنها برش نیاز به گاز دارد'); ?></li>
                    <li> <?php pll_e('تکنولوژی بهینه برای برش مواد صیقلی'); ?> </li>
                    <li> <?php pll_e('انتخاب ایده آل برای صغحات نازک'); ?> </li>
                    <li> <?php pll_e('سرعت برش غیر قابل رقابت'); ?> </li>
                    <li> <?php pll_e('بهترین کیفیت، تطبیق پذیری و نسبت قیمت'); ?> </li>
                    <li> <?php pll_e('هزینه کاهش یافته ی نگهداری'); ?> </li>
                </ul>
                <p class="text-center">
                    <a href="http://www.adira.pt/clidocs/Gr38_71_0.pdf" class="btn btn-primary btn-special"><i class="fa fa-download" aria-hidden="true"></i> <?php pll_e('دانلود کاتالوگ'); ?></a>
                </p>
            </div>
            <div class="col-lg-6 px-5 py-4 py-lg-0" <?php if(is_rtl()){ ?>dir="rtl"<?php } else { ?>dir="ltr"<?php } ?>>
                <div id="Blue-Laser-carousel" class="navbar-change carousel slide" data-ride="carousel" data-interval="3000" data-pause="hover">
                    <ol class="carousel-indicators">
                        <li data-target="#Blue-Laser-carousel" data-slide-to="0" class="active"></li>
                        <li data-target="#Blue-Laser-carousel" data-slide-to="1"></li>
                    </ol>
                    <div class="carousel-inner">
                        <div class="carousel-item active">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/Blue_Laser/UplImg_35_67_355.jpg" alt="Blue Laser">
                        </div>
                        <div class="carousel-item">
                            <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/slider/Blue_Laser/UplImg_35_67_417.jpg" alt="Blue Laser">
                        </div>
                    </div>
                    <a class="carousel-control-prev" href="#Blue-Laser-carousel" role="button" data-slide="prev">
                        <i class="fa fa-angle-<?php if(is_rtl()){ ?>right<?php } else { ?>left<?php } ?> fa-3x" aria-hidden="true"></i>
                        <span class="sr-only">Previous</span>
                    </a>
                    <a class="carousel-control-next" href="#Blue-Laser-carousel" role="button" data-slide="next">
                        <i class="fa fa-angle-<?php if(is_rtl()){ ?>left<?php } else { ?>right<?php } ?> fa-3x" aria-hidden="true"></i>
                        <span class="sr-only">Next</span>
                    </a>
                </div>
            </div>
        </div>
        <div class="my-5 py-5"></div>
    </div>
<?php
get_footer();
