<?php
/**
 * Template Name: Contact Us
 */

get_header(); ?>
<div class="bg-blue pb-0 pb-sm-5">
    <div class="contact-us-page container">
        <div class="py-5"></div>
        <div class="py-5"></div>
        <div class="row title mb-2">
            <div class="col-sm-12">
                <div class="row">
                    <div class="col-12">
                        <div class="py-0 py-sm-3 p-md-5"></div>
                        <div class="animation-slide-up">
                            <h1 class="text-center font-weight-bold"><?php pll_e('ارتباط با ما'); ?></h1>
                        </div>
                        <i class="fa fa-envelope position-absolute bg bg-center text-white" aria-hidden="true" style="top:-65px; z-index: 0;"></i>
                    </div>
                    <div class="col-md-6 offset-md-3 col-sm-8 offset-sm-2 col-12 offset-0 position-relative">
                        <div class="d-flex flex-row justify-content-center align-items-center">
                            <hr class="border-white" style="width: 45%; opacity: .5;">
                            <i class="fa fa-angle-double-down fa-2x text-center text-white angle" aria-hidden="true"></i>
                            <hr class="border-white" style="width: 45%; opacity: .5;">
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="py-5"></div>
        <div class="row box-shadow position-relative">
            <div class="col-lg-6 form-linear bg-white py-5">
                <form id="contactForm" novalidate autocomplete="off">
                    <div class="form-row">
                        <div class="form-group col-sm-10 offset-sm-1">
                            <div class="form-group row">
                                <div class="col-sm-12">
                                    <input type="text" name="name" id="name" class="form-control" placeholder="<?php pll_e('نام شما:'); ?>" value="">
                                </div>
                            </div>
                            <div class="form-group row">
                                <div class="col-sm-12">
                                    <input type="text" name="email" id="email" class="form-control" placeholder="<?php pll_e('ایمیل شما:'); ?>" value="">
                                </div>
                            </div>
                            <div class="form-group row">
                                <div class="col-sm-12">
                                    <input type="text" name="phone" id="phone" class="form-control" placeholder="<?php pll_e('تلفن شما:'); ?>" value="">
                                </div>
                            </div>
                            <div class="form-group row">
                                <div class="col-sm-12">
                                    <input type="text" name="postalCode" id="postalCode" class="form-control" placeholder="<?php pll_e('کد پستی:'); ?>" value="">
                                </div>
                            </div>
                            <div class="form-group row">
                                <div class="col-sm-12">
                                    <input type="text" name="companyName" id="companyName" class="form-control" placeholder="<?php pll_e('نام شرکت شما:'); ?>" value="">
                                </div>
                            </div>
                            <div class="form-group row">
                                <div class="col-sm-12 mt-2">
                                    <textarea class="form-control" name="comment" id="comment" rows="5" placeholder="<?php pll_e('پیام شما:'); ?>"></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-row justify-content-center pb-3">
                        <div class="g-recaptcha" data-sitekey="6LfR9UcUAAAAAHX-CxiRHeJRSX_ISZpK1jXygGwL"></div>
                    </div>
                    <div class="form-row">
                        <div class="form-group col-sm-12 text-center">
                            <button type="submit" class="btn btn-primary btn-special btn-lg"><?php pll_e('ارسال پیام'); ?></button>
                            <input type="hidden" name="submitted" id="submitted" value="1" />
                        </div>
                    </div>
                    <div class="form-row justify-content-center">
                        <div id="contact-us-status" class="alert" role="alert"></div>
                    </div>
                </form>
            </div>
            <div class="col-lg-6 left-col py-5">
                <div class="row">
                    <div class="col-sm-8 offset-sm-2">
                        <div class="row">
                            <div class="col-sm-3 d-flex align-items-center justify-content-center">
                                <i class="fa fa-phone fa-5x" aria-hidden="true"></i>
                            </div>
                            <div class="col-sm-9 text-center">
                                <h3 class="font-weight-bold mb-0" dir="ltr">+98 21 88764110</h3>
                                <h3 class="font-weight-bold mb-0" dir="ltr">+98 21 88766904</h3>
                            </div>
                        </div>
                    </div>
                </div>
                <hr class="w-75">
                <div class="row">
                    <div class="col-sm-8 offset-sm-2">
                        <div class="row">
                            <div class="col-sm-3 d-flex align-items-center justify-content-center">
                                <i class="fa fa-map-marker fa-5x" aria-hidden="true"></i>
                            </div>
                            <div class="col-sm-9 text-center">
                                <h5><?php pll_e( 'ونک، انتهای برزیل شرقی، بعد از دیوان محاسبات، کوی لاله، پلاک ۶، واحد ۳۰۲'); ?></h5>
                            </div>
                        </div>
                    </div>
                </div>
                <hr class="w-75">
                <div class="row">
                    <div class="col-sm-8 offset-sm-2">
                        <div class="row">
                            <div class="col-sm-3 d-flex align-items-center justify-content-center">
                                <i class="fa fa-fax fa-3x" aria-hidden="true"></i>
                            </div>
                            <div class="col-sm-9 text-center">
                                <h3 class="font-weight-bold" dir="ltr">+98 21 86085192</h3>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="position-social">
                    <div class="row social">
                        <div class="col-12 pt-5 mt-5 d-flex align-items-center justify-content-center justify-content-lg-end">
                            <a class="m-1 d-flex align-items-center justify-content-center" href="https://www.linkedin.com/in/ratin-tajhiz-alborz-94176869" target="_blank">
                                <img src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/social_network/linkedin.png">
                            </a>
                            <a class="m-1 d-flex align-items-center justify-content-center" href="https://www.instagram.com/ratintajhiz" target="_blank">
                                <img src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/social_network/instagram.png">
                            </a>
                            <a class="m-1 d-flex align-items-center justify-content-center" href="http://T.me/ratintajhiz" target="_blank">
                                <img src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/social_network/telegram.png">
                            </a>
                            <a class="m-1 d-flex align-items-center justify-content-center" href="http://T.me/ratintajhiz" target="_blank">
                                <img src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/social_network/aparat.png" style="width: 26px; height: 26px;">
                            </a>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12 text-center text-lg-left" dir="ltr">
                            <small>
                                Ratin Tajhiz © <?php echo date('Y'); ?> All Rights Reserved.
                            </small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
</body>
</html>

