<?php
/**
 * Template Name: Home Page
 */

get_header();
$url_num = '';
if(get_bloginfo('language')=='en-US'){
	$url_num = '-2';
}
?>
    <div class="home-header bg-blue container-fluid p-0">
        <div class="bg">
            <img src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="bg-1">
            <img src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="bg-2">
            <img src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="bg-3">
            <img src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="bg-4">
            <img src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="bg-5">
        </div>
        <div class="content d-flex flex-column justify-content-center align-items-center">
            <div class="video d-flex justify-content-center align-items-center">
                <div>
                    <video preload="none" loop="" autoplay="" muted="" data-replace="false">
                        <source src="<?php echo get_template_directory_uri(); ?>/inc/assets/media/vr.mp4" type="video/mp4">
                    </video>
                </div>
                <div>
                    <video preload="none" loop="" autoplay="" muted="" data-replace="false">
                        <source src="<?php echo get_template_directory_uri(); ?>/inc/assets/media/vc.mp4" type="video/mp4">
                    </video>
                </div>
                <div>
                    <video preload="none" loop="" autoplay="" muted="" data-replace="false">
                        <source src="<?php echo get_template_directory_uri(); ?>/inc/assets/media/vl.mp4" type="video/mp4">
                    </video>
                </div>
            </div>
            <div class="text d-flex flex-column justify-content-center align-items-center">
                <div class="home-title pt-5">
                    <h1 class="text-center p-2 title-1"><?php pll_e('تکنولوژی‌ها و راهکارهای شیت‌متال'); ?></h1>
                    <h1 class="text-center title-2"><?php pll_e('لیزر'); ?><span style="font-size: 0.6em;"> / </span><?php pll_e('پرس‌بریک'); ?><span style="font-size: 0.6em;"> / </span><?php pll_e('گیوتین'); ?><span style="font-size: 0.6em;"> / </span><?php pll_e( 'نرم‌افزار'); ?></h1>
                    <h2 class="text-center title-3 pt-5 mb-0">"<?php pll_e('بهتر امکان پذیر است'); ?>"</h2>
                </div>
                <form role="search" method="get" id="searchform" action="<?php echo home_url( '/' ); ?>" autocomplete="off">
                    <div class="form-linear p-1 d-flex flex-column justify-content-center align-items-center">
                        <div class="input-search d-flex justify-content-center align-items-center">
                            <div class="input-group" style="min-width: 23vw;">
                                <input type="text" class="form-control" name="s">
                                <span class="input-group-btn">
                                    <button class="btn btn-secondary btn-search" type="submit"><i class="fa fa-search" aria-hidden="true"></i></button>
                                </span>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <span class="scroll-btn">scroll</span>
        </div>
    </div>
    <div id="home-carousel" class="navbar-change carousel slide home-carousel" data-ride="home-carousel">
        <ol class="carousel-indicators">
            <li data-target="#home-carousel" data-slide-to="0" class="active"></li>
            <li data-target="#home-carousel" data-slide-to="1"></li>
            <li data-target="#home-carousel" data-slide-to="2"></li>
            <li data-target="#home-carousel" data-slide-to="3"></li>
            <li data-target="#home-carousel" data-slide-to="4"></li>
            <li data-target="#home-carousel" data-slide-to="5"></li>
            <li data-target="#home-carousel" data-slide-to="6"></li>
        </ol>
        <div class="carousel-inner position-relative">
            <div class="carousel-item active">
                <a href="<?php echo esc_url( home_url( '/' )); ?>press_brakes<?php echo $url_num; ?>" class="btn btn-primary btn-special btn-lg position-absolute" role="button"><span class="d-none d-md-block"><?php pll_e('اطلاعات بیشتر...'); ?></span><span class="d-block d-md-none"><i class="fa fa-long-arrow-left"></i></span></a>
                <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/ADIRA.jpg" alt="">
            </div>
            <div class="carousel-item">
                <a href="<?php echo esc_url( home_url( '/' )); ?>hexa_c<?php echo $url_num; ?>" class="btn btn-primary btn-special btn-lg position-absolute" role="button"><span class="d-none d-md-block"><?php pll_e('اطلاعات بیشتر...'); ?></span><span class="d-block d-md-none"><i class="fa fa-long-arrow-left"></i></span></a>
                <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/Adira_hexa_C_en-01.jpg" alt="">
            </div>
            <div class="carousel-item">
                <a href="<?php echo esc_url( home_url( '/' )); ?>laser<?php echo $url_num; ?>" class="btn btn-primary btn-special btn-lg position-absolute" role="button"><span class="d-none d-md-block"><?php pll_e('اطلاعات بیشتر...'); ?></span><span class="d-block d-md-none"><i class="fa fa-long-arrow-left"></i></span></a>
                <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/Adira-Laser.jpg" alt="">
            </div>
            <div class="carousel-item">
                <a href="<?php echo esc_url( home_url( '/' )); ?>shears<?php echo $url_num; ?>" class="btn btn-primary btn-special btn-lg position-absolute" role="button"><span class="d-none d-md-block"><?php pll_e('اطلاعات بیشتر...'); ?></span><span class="d-block d-md-none"><i class="fa fa-long-arrow-left"></i></span></a>
                <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/Adira-Shear.jpg" alt="">
            </div>
            <div class="carousel-item">
                <a href="<?php echo esc_url( home_url( '/' )); ?>software<?php echo $url_num; ?>" class="btn btn-primary btn-special btn-lg position-absolute" role="button"><span class="d-none d-md-block"><?php pll_e('اطلاعات بیشتر...'); ?></span><span class="d-block d-md-none"><i class="fa fa-long-arrow-left"></i></span></a>
                <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/Lantek flyer-01.jpg" alt="">
            </div>
            <div class="carousel-item">
                <a href="<?php echo esc_url( home_url( '/' )); ?>parmastamp<?php echo $url_num; ?>" class="btn btn-primary btn-special btn-lg position-absolute" role="button"><span class="d-none d-md-block"><?php pll_e('اطلاعات بیشتر...'); ?></span><span class="d-block d-md-none"><i class="fa fa-long-arrow-left"></i></span></a>
                <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/ParmaStamp.jpg" alt="">
            </div>
            <div class="carousel-item">
                <a href="<?php echo esc_url( home_url( '/' )); ?>ciemmegi<?php echo $url_num; ?>" class="btn btn-primary btn-special btn-lg position-absolute" role="button"><span class="d-none d-md-block"><?php pll_e('اطلاعات بیشتر...'); ?></span><span class="d-block d-md-none"><i class="fa fa-long-arrow-left"></i></span></a>
                <img class="d-block w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/Punch-Tooling.jpg" alt="">
            </div>
        </div>
        <a class="carousel-control-prev" href="#home-carousel" role="button" data-slide="prev">
            <?php if(is_rtl()){ ?>
                <i class="fa fa-angle-right fa-4x d-none d-lg-block" aria-hidden="true"></i>
                <i class="fa fa-angle-right fa-2x d-lg-none d-md-block" aria-hidden="true"></i>
            <?php } else { ?>
                <i class="fa fa-angle-left fa-4x d-none d-lg-block" aria-hidden="true"></i>
                <i class="fa fa-angle-left fa-2x d-lg-none d-md-block" aria-hidden="true"></i>
            <?php } ?>
            <span class="sr-only">Previous</span>
        </a>
        <a class="carousel-control-next" href="#home-carousel" role="button" data-slide="next">
	        <?php if(is_rtl()){ ?>
                <i class="fa fa-angle-left fa-4x d-none d-lg-block" aria-hidden="true"></i>
                <i class="fa fa-angle-left fa-2x d-lg-none d-md-block" aria-hidden="true"></i>
	        <?php } else { ?>
                <i class="fa fa-angle-right fa-4x d-none d-lg-block" aria-hidden="true"></i>
                <i class="fa fa-angle-right fa-2x d-lg-none d-md-block" aria-hidden="true"></i>
	        <?php } ?>
            <span class="sr-only">Next</span>
        </a>
    </div>
    <div class="container-fluid service pt-2" id="product">
        <div class="row title mb-2">
            <div class="col-sm-12 pt-5">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="animation-slide-up">
                            <h2 class="text-center font-weight-light"><?php pll_e('خدمات ما'); ?></h2>
                            <h1 class="text-center font-weight-bold"><?php pll_e('به شما'); ?></h1>
                        </div>
                        <i class="fa fa-cogs position-absolute bg bg-center" aria-hidden="true" style="top:-50px;"></i>
                    </div>
                    <div class="col-md-6 offset-md-3 col-sm-8 offset-sm-2 col-12 offset-0 position-relative">
                        <div class="d-flex flex-row justify-content-center align-items-center">
                            <hr style="width: 45%;">
                            <i class="fa fa-angle-double-down fa-2x text-center angle" aria-hidden="true"></i>
                            <hr style="width: 45%;">
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row mt-5 mx-1 justify-content-center">
            <a class="col-lg col-md-4 col-12 pt-2 px-2 position-relative text-center" href="<?php echo esc_url( home_url( '/' )); ?>adira<?php echo $url_num; ?>">
                <img src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/machines.jpg">
                <h5 class="font-weight-bold my-2"><?php pll_e('ماشین‌های ورق‌کاری'); ?></h5>
                <p class="text text-center d-none d-sm-none d-md-block"><?php pll_e('با مشاوره، تامین و تجهیز خطوط تولیدی شما با ماشین‌های لیزر، پرس‌بریک و گیوتین در خدمت شما هستیم'); ?></p>
                <div class="bg position-absolute"></div>
            </a>
            <a class="col-lg col-md-4 col-12 pt-2 px-2 position-relative text-center" href="<?php echo esc_url( home_url( '/' )); ?>ciemmegi<?php echo $url_num; ?>">
                <img src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/punch_tooling.jpg">
                <h5 class="font-weight-bold my-2"><?php pll_e('قالب‌های پانچ سی‌ان‌سی'); ?></h5>
                <p class="text text-center d-none d-sm-none d-md-block"><?php pll_e('در انتخاب، تامین و نگهداری از ابزارهای پانچتان در کنار شما هستیم'); ?></p>
                <div class="bg position-absolute"></div>
            </a>
            <a class="col-lg col-md-4 col-12 pt-2 px-2 position-relative text-center" href="<?php echo esc_url( home_url( '/' )); ?>parmastamp<?php echo $url_num; ?>">
                <img src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/press_brake_bending.jpg">
                <h5 class="font-weight-bold my-2"><?php pll_e('قالب‌های پرس‌بریک'); ?></h5>
                <p class="text text-center d-none d-sm-none d-md-block"><?php pll_e('با مشاوره در انتخاب و تامین قالب‌های پرس‌بریک شما از برند معتبر اروپایی در خدمت شما هستیم'); ?></p>
                <div class="bg position-absolute"></div>
            </a>
            <a class="col-lg col-md-4 col-12 pt-2 px-2 position-relative text-center" href="<?php echo esc_url( home_url( '/' )); ?>software<?php echo $url_num; ?>">
                <img src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/lantek_cadcam_software.png">
                <h5 class="font-weight-bold my-2"><?php pll_e('نرم‌افزارهای ورق‌کاری'); ?></h5>
                <p class="text text-center d-none d-sm-none d-md-block"><?php pll_e('از 0 تا 100 ورق‌کاری را با نرم‌فزارهای lantek مدیریت کنید نرم‌افزارهای lantek manager نرم‌افزارهای برش لیزر، پلاسما، واترجت و هواگاز نرم افزار پانچ'); ?></p>
                <div class="bg position-absolute"></div>
            </a>
            <a class="col-lg col-md-4 col-12 pt-2 px-2 position-relative text-center" href="<?php echo esc_url( home_url( '/' )); ?>training<?php echo $url_num; ?>">
                <img src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/services.png">
                <h5 class="font-weight-bold my-2"><?php pll_e('مشاوره و آموزش'); ?></h5>
                <p class="text text-center d-none d-sm-none d-md-block"><?php pll_e('مشاوره در بهینه‌سازی خطوط ورق‌کاری، مشاوره و آموزش در استفاده بهینه از ماشین آلات ورق‌کاری، آموزش لیزر، پانچ، پرس‌بریک و نرم افزار Lantek'); ?></p>
                <div class="bg position-absolute"></div>
            </a>
        </div>
    </div>
    <div class="customer container pt-5">
        <div class="row justify-content-end" dir="rtl" style="z-index: 1; padding-top: 8rem;">
            <div class="col-xl-5 col-lg-5 d-none d-lg-block">
                <p class="text-justify"><?php pll_e('راتین تجهیز البرز افتخار همکاری با صنایع مختلفی را داشته و همواره به دنبال بدست آوردن عمیق ترین اعتماد مشتریان خود می باشد.'); ?></p>
                <a href="<?php echo esc_url( home_url( '/' )); ?>coming_soon" class="btn btn-primary btn-special btn-lg float-left" role="button"><?php pll_e('مشاهده مشتریان ما'); ?></a>
            </div>
            <div class="col-xl-4 col-lg-5 d-none d-lg-block">
                <div class="row title">
                    <div class="col-sm-12 mb-2">
                        <div class="animation-slide-up">
                            <h2 class="text-left font-weight-light mb-0"><?php pll_e('افتخار ما'); ?></h2>
                            <h1 class="text-left font-weight-bold mb-0"><?php pll_e('مشتریان ما'); ?></h1>
                        </div>
                        <div class="clearfix">
                            <hr class="w-75 float-left">
                            <i class="fa fa-angle-double-right fa-2x float-left" aria-hidden="true"></i>
                        </div>
                        <i class="bg bg-left fa fa-users position-absolute" aria-hidden="true" style="top:-105px;"></i>
                    </div>
                </div>
            </div>
            <div class="col-12 d-block d-lg-none">
                <div class="row title">
                    <div class="col-sm-12 mb-2">
                        <div class="animation-slide-up">
                            <h2 class="text-left font-weight-light mb-0"><?php pll_e('افتخار ما'); ?></h2>
                            <h1 class="text-left font-weight-bold mb-0"><?php pll_e('مشتریان ما'); ?></h1>
                        </div>
                        <div class="clearfix">
                            <hr class="w-50 float-left">
                            <i class="fa fa-angle-double-right fa-2x float-left" aria-hidden="true"></i>
                        </div>
                        <i class="bg bg-left fa fa-users position-absolute" aria-hidden="true" style="top:-50px;"></i>
                    </div>
                </div>
            </div>
            <div class="col-12 d-block d-lg-none">
                <p class="text-justify"><?php pll_e('راتین تجهیز البرز افتخار همکاری با صنایع مختلفی را داشته و همواره به دنبال بدست آوردن عمیق ترین اعتماد مشتریان خود می باشد.'); ?></p>
                <a href="<?php echo esc_url( home_url( '/' )); ?>coming_soon" class="btn btn-primary btn-special btn-lg float-left" role="button"><?php pll_e('مشاهده مشتریان ما'); ?></a>
            </div>
        </div>
    </div>
    <div class="customer container-fluid">
        <div class="logo row">
            <div class="col-sm-12 p-0">
                <img class="position-relative" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/ratin100.png">
            </div>
        </div>
    </div>
    <div class="partner container" style="padding-top: 12rem;">
        <div class="row" dir="rtl">
            <div class="col-lg-4">
                <div class="row title">
                    <div class="col-sm-12 mb-2">
                        <div class="animation-slide-up">
                            <h2 class="text-right font-weight-light mb-0"><?php pll_e('شرکای'); ?></h2>
                            <h1 class="text-right font-weight-bold mb-0"><?php pll_e('تجاری'); ?></h1>
                        </div>
                        <div class="clearfix">
                            <hr class="w-50 float-right">
                            <i class="fa fa-angle-double-left fa-2x float-right" aria-hidden="true"></i>
                        </div>
                        <i class="bg bg-right fa fa-handshake-o position-absolute" aria-hidden="true" style="top:-50px;"></i>
                    </div>
                </div>
            </div>
            <div class="map col-lg-8">
                <img src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/partner_map.png">
            </div>
        </div>
        <div class="row">
            <div class="col-sm-12 py-5 mb-5">
                <ul class="nav nav-pills nav-fill mb-5" id="pills-tab" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link py-3 active en text-center" id="machines-tab" data-toggle="pill" href="#machines" role="tab" aria-controls="machines" aria-selected="true"><strong>Machines</strong></a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link py-3 en text-center" id="punch-tooling-tab" data-toggle="pill" href="#punch-tooling" role="tab" aria-controls="punch-tooling" aria-selected="false"><strong>Punch Tooling</strong></a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link py-3 en text-center" id="press-brake-tab" data-toggle="pill" href="#press-brake" role="tab" aria-controls="press-brake" aria-selected="false"><strong>Press Brake</strong></a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link py-3 en text-center" id="cadcam-software-tab" data-toggle="pill" href="#cadcam-software" role="tab" aria-controls="cadcam-software" aria-selected="false"><strong>CadCam Software</strong></a>
                    </li>
                </ul>
                <div class="tab-content" id="pills-tabContent">
                    <div class="tab-pane show active" id="machines" role="tabpanel" aria-labelledby="machines-tab">
                        <div class="row justify-content-center">
                            <div class="col-lg-3 col-md-4 col-sm-6">
                                <a class="d-flex justify-content-center align-items-center w-100 position-relative" href="http://www.adira.pt/" target="_blank">
                                    <img class="w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/P4-compressor.jpg">
                                    <div class="text d-flex justify-content-center align-items-center w-100">
                                        <strong>Adira</strong>
                                        <small class="fixed-bottom mx-2 my-1"><i class="fa fa-external-link" aria-hidden="true"></i> <?php pll_e('مشاهده وبسایت'); ?></small>
                                    </div>
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane" id="punch-tooling" role="tabpanel" aria-labelledby="punch-tooling-tab">
                        <div class="row justify-content-center">
                            <div class="col-lg-3 col-md-4 col-sm-6">
                                <a class="d-flex justify-content-center align-items-center w-100 position-relative" href="http://www.ciemmegi.it/" target="_blank">
                                    <img class="w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/P2-compressor.jpg">
                                    <div class="text d-flex justify-content-center align-items-center w-100">
                                        <strong>Ciemmegi</strong>
                                        <small class="fixed-bottom mx-2 my-1"><i class="fa fa-external-link" aria-hidden="true"></i> <?php pll_e('مشاهده وبسایت'); ?></small>
                                    </div>
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane" id="press-brake" role="tabpanel" aria-labelledby="press-brake-tab">
                        <div class="row justify-content-center">
                            <div class="col-lg-3 col-md-4 col-sm-6">
                                <a class="d-flex justify-content-center align-items-center w-100 position-relative" href="http://www.parmastamp.eu/" target="_blank">
                                    <img class="w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/P1-compressor.png">
                                    <div class="text d-flex justify-content-center align-items-center w-100">
                                        <strong>Parmastamp</strong>
                                        <small class="fixed-bottom mx-2 my-1"><i class="fa fa-external-link" aria-hidden="true"></i> <?php pll_e('مشاهده وبسایت'); ?></small>
                                    </div>
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane" id="cadcam-software" role="tabpanel" aria-labelledby="cadcam-software-tab">
                        <div class="row justify-content-center">
                            <div class="col-lg-3 col-md-4 col-sm-6">
                                <a class="d-flex justify-content-center align-items-center w-100 position-relative" href="http://www.lanteksms.com/" target="_blank">
                                    <img class="w-100" src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/P3-compressor.jpg">
                                    <div class="text d-flex justify-content-center align-items-center w-100">
                                        <strong>Lantek</strong>
                                        <small class="fixed-bottom mx-2 my-1"><i class="fa fa-external-link" aria-hidden="true"></i> <?php pll_e('مشاهده وبسایت'); ?></small>
                                    </div>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="article container-fluid">
        <div class="row title mb-2">
            <div class="col-sm-12 pt-5">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="animation-slide-up">
                            <h1 class="text-center font-weight-bold"><?php pll_e('چکیده مقالات'); ?></h1>
                        </div>
                        <i class="fa fa-file-text position-absolute bg bg-center" aria-hidden="true" style="top:-90px;"></i>
                    </div>
                    <div class="col-md-6 offset-md-3 col-sm-8 offset-sm-2 col-12 offset-0 position-relative">
                        <div class="d-flex flex-row justify-content-center align-items-center">
                            <hr style="width: 45%;">
                            <i class="fa fa-angle-double-down fa-2x text-center angle" aria-hidden="true"></i>
                            <hr style="width: 45%;">
                        </div>
                        <a class="btn btn-primary btn-sm position-absolute mx-1 d-none d-sm-block" href="<?php echo esc_url( home_url( '/' )); ?>articles<?php echo $url_num; ?>"><?php pll_e('مشاهده همه مقالات'); ?> <i class="fa fa-plus" aria-hidden="true"></i></a>
                        <a class="btn btn-primary btn-sm position-absolute mx-1 d-block d-sm-none" href="<?php echo esc_url( home_url( '/' )); ?>articles<?php echo $url_num; ?>"><i class="fa fa-plus" aria-hidden="true"></i></a>
                    </div>
                </div>
            </div>
        </div>
        <div class="row content">
            <div class="col-sm-12 pt-5">
                <div id="carousel-post" class="navbar-change carousel slide px-lg-5 px-4" data-ride="carousel">
                    <div class="carousel-inner px-lg-5 px-sm-2 px-0">
                        <?php
                        $loop = new WP_Query( 'showposts=5' );
                        $i =0;
                        while ( $loop->have_posts() ) : $loop->the_post();
                        ?>
                            <div class="carousel-item<?php echo $i==0 ? ' active' : '';?>">
                                <div class="row">
                                    <div class="col-lg-3 col-md-5 col-sm-12 d-flex justify-content-center align-items-center">
                                        <?php if ( has_post_thumbnail() ) : ?>
                                            <img class="img-fluid img-thumbnail mr-3 p-3" src="<?php the_post_thumbnail_url('thumbnail'); ?>" alt="<?php the_title(); ?>">
                                        <?php endif; ?>
                                    </div>
                                    <div class="col-lg-9 col-md-7 col-sm-12">
                                        <h5 class="pt-3 pt-md-0 font-weight-bold text-center <?php echo is_rtl() ? 'text-md-right' : 'text-md-left'; ?>"><?php the_title(); ?></h5>
                                        <p class="text-justify"><?php echo excerpt(72); ?></p>
                                        <a class="btn btn-primary btn-sm" href="<?php the_permalink(); ?>"><?php pll_e('مطالعه ادامه مقاله'); ?> <i class="fa fa-long-arrow-<?php if(is_rtl()){ ?>left<?php } else { ?>right<?php } ?>" aria-hidden="true"></i></a>
                                    </div>
                                </div>
                            </div>
                        <?php
                        $i++;
                        endwhile;
                        wp_reset_postdata();
                        ?>
                    </div>
                    <a class="carousel-control-prev" href="#carousel-post" role="button" data-slide="prev">
                        <i class="fa fa-angle-<?php if(is_rtl()){ ?>right<?php } else { ?>left<?php } ?> fa-2x" aria-hidden="true"></i>
                        <span class="sr-only">Previous</span>
                    </a>
                    <a class="carousel-control-next" href="#carousel-post" role="button" data-slide="next">
                        <i class="fa fa-angle-<?php if(is_rtl()){ ?>left<?php } else { ?>right<?php } ?> fa-2x" aria-hidden="true"></i>
                        <span class="sr-only">Next</span>
                    </a>
                </div>
            </div>
        </div>
    </div>
<?php
get_footer();
