<?php
/**
 * WP Bootstrap Starter functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package WP_Bootstrap_Starter
 */

if ( ! function_exists( 'wp_bootstrap_starter_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function wp_bootstrap_starter_setup() {
	/*
	 * Make theme available for translation.
	 * Translations can be filed in the /languages/ directory.
	 * If you're building a theme based on WP Bootstrap Starter, use a find and replace
	 * to change 'wp-bootstrap-starter' to the name of your theme in all the template files.
	 */
	load_theme_textdomain( 'wp-bootstrap-starter', get_template_directory() . '/languages' );

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	/*
	 * Let WordPress manage the document title.
	 * By adding theme support, we declare that this theme does not use a
	 * hard-coded <title> tag in the document head, and expect WordPress to
	 * provide it for us.
	 */
	add_theme_support( 'title-tag' );

	/*
	 * Enable support for Post Thumbnails on posts and pages.
	 *
	 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
	 */
	add_theme_support( 'post-thumbnails' );

	// This theme uses wp_nav_menu() in one location.
	register_nav_menus( array(
		'primary' => esc_html__( 'Primary', 'wp-bootstrap-starter' ),
	) );

	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support( 'html5', array(
		'comment-form',
		'comment-list',
		'gallery',
		'caption',
	) );

	// Set up the WordPress core custom background feature.
	add_theme_support( 'custom-background', apply_filters( 'wp_bootstrap_starter_custom_background_args', array(
		'default-color' => 'ffffff',
		'default-image' => '',
	) ) );

	// Add theme support for selective refresh for widgets.
	add_theme_support( 'customize-selective-refresh-widgets' );

    function wp_boostrap_starter_add_editor_styles() {
        add_editor_style( 'custom-editor-style.css' );
    }
    add_action( 'admin_init', 'wp_boostrap_starter_add_editor_styles' );

}
endif;
add_action( 'after_setup_theme', 'wp_bootstrap_starter_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function wp_bootstrap_starter_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'wp_bootstrap_starter_content_width', 1170 );
}
add_action( 'after_setup_theme', 'wp_bootstrap_starter_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function wp_bootstrap_starter_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar', 'wp-bootstrap-starter' ),
		'id'            => 'sidebar-1',
		'description'   => esc_html__( 'Add widgets here.', 'wp-bootstrap-starter' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );
    register_sidebar( array(
        'name'          => esc_html__( 'Footer 1', 'wp-bootstrap-starter' ),
        'id'            => 'footer-1',
        'description'   => esc_html__( 'Add widgets here.', 'wp-bootstrap-starter' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ) );
    register_sidebar( array(
        'name'          => esc_html__( 'Footer 2', 'wp-bootstrap-starter' ),
        'id'            => 'footer-2',
        'description'   => esc_html__( 'Add widgets here.', 'wp-bootstrap-starter' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ) );
    register_sidebar( array(
        'name'          => esc_html__( 'Footer 3', 'wp-bootstrap-starter' ),
        'id'            => 'footer-3',
        'description'   => esc_html__( 'Add widgets here.', 'wp-bootstrap-starter' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ) );
}
add_action( 'widgets_init', 'wp_bootstrap_starter_widgets_init' );



/**
 * Enqueue scripts and styles.
 */
function wp_bootstrap_starter_scripts() {
	// load bootstrap css
	if ( is_rtl() ) {
		wp_enqueue_style( 'wp-bootstrap-starter-bootstrap-css', get_template_directory_uri() . '/inc/assets/css/bootstrap/rtl/bootstrap.min.css' );
	} else {
		wp_enqueue_style( 'wp-bootstrap-starter-bootstrap-css', get_template_directory_uri() . '/inc/assets/css/bootstrap/ltr/bootstrap.min.css' );
		wp_enqueue_style( 'wp-bootstrap-starter-bootstrap-css-font', 'https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,300i,400,400i,600,600i,700,700i,900,900i|Montserrat|Oswald' );
	}
	//wp_enqueue_style( 'wp-bootstrap-starter-bootstrap-css-rtl', get_template_directory_uri() . '/inc/assets/css/bootstrap-rtl.min.css' );
	// load bootstrap css
	wp_enqueue_style( 'wp-bootstrap-starter-font-awesome', get_template_directory_uri() . '/inc/assets/css/font-awesome.min.css', false, '4.1.0' );
	// load AItheme styles
	// load WP Bootstrap Starter styles
	wp_enqueue_style( 'wp-bootstrap-starter-style', get_stylesheet_uri() );
    if(get_theme_mod( 'preset_style_setting' ) === 'poppins-lora') {
        wp_enqueue_style( 'wp-bootstrap-starter-poppins-lora-font', '//fonts.googleapis.com/css?family=Lora:400,400i,700,700i|Poppins:300,400,500,600,700' );
    }
    if(get_theme_mod( 'preset_style_setting' ) === 'montserrat-merriweather') {
        wp_enqueue_style( 'wp-bootstrap-starter-montserrat-merriweather-font', '//fonts.googleapis.com/css?family=Merriweather:300,400,400i,700,900|Montserrat:300,400,400i,500,700,800' );
    }
    if(get_theme_mod( 'preset_style_setting' ) === 'poppins-poppins') {
        wp_enqueue_style( 'wp-bootstrap-starter-poppins-font', '//fonts.googleapis.com/css?family=Poppins:300,400,500,600,700' );
    }
    if(get_theme_mod( 'preset_style_setting' ) === 'roboto-roboto') {
        wp_enqueue_style( 'wp-bootstrap-starter-roboto-font', '//fonts.googleapis.com/css?family=Roboto:300,300i,400,400i,500,500i,700,700i,900,900i' );
    }
    if(get_theme_mod( 'preset_style_setting' ) === 'arbutusslab-opensans') {
        wp_enqueue_style( 'wp-bootstrap-starter-arbutusslab-opensans-font', '//fonts.googleapis.com/css?family=Arbutus+Slab|Open+Sans:300,300i,400,400i,600,600i,700,800' );
    }
    if(get_theme_mod( 'preset_style_setting' ) === 'oswald-muli') {
        wp_enqueue_style( 'wp-bootstrap-starter-oswald-muli-font', '//fonts.googleapis.com/css?family=Muli:300,400,600,700,800|Oswald:300,400,500,600,700' );
    }
    if(get_theme_mod( 'preset_style_setting' ) === 'montserrat-opensans') {
        wp_enqueue_style( 'wp-bootstrap-starter-montserrat-opensans-font', '//fonts.googleapis.com/css?family=Montserrat|Open+Sans:300,300i,400,400i,600,600i,700,800' );
    }
    if(get_theme_mod( 'preset_style_setting' ) === 'robotoslab-roboto') {
        wp_enqueue_style( 'wp-bootstrap-starter-robotoslab-roboto', '//fonts.googleapis.com/css?family=Roboto+Slab:100,300,400,700|Roboto:300,300i,400,400i,500,700,700i' );
    }
    if(get_theme_mod( 'preset_style_setting' ) && get_theme_mod( 'preset_style_setting' ) !== 'default') {
        wp_enqueue_style( 'wp-bootstrap-starter-'.get_theme_mod( 'preset_style_setting' ), get_template_directory_uri() . '/inc/assets/css/presets/typography/'.get_theme_mod( 'preset_style_setting' ).'.css', false, '' );
    }
    //Color Scheme
    /*if(get_theme_mod( 'preset_color_scheme_setting' ) && get_theme_mod( 'preset_color_scheme_setting' ) !== 'default') {
        wp_enqueue_style( 'wp-bootstrap-starter-'.get_theme_mod( 'preset_color_scheme_setting' ), get_template_directory_uri() . '/inc/assets/css/presets/color-scheme/'.get_theme_mod( 'preset_color_scheme_setting' ).'.css', false, '' );
    }else {
        wp_enqueue_style( 'wp-bootstrap-starter-default', get_template_directory_uri() . '/inc/assets/css/presets/color-scheme/blue.css', false, '' );
    }*/

	wp_enqueue_script('jquery');

    // Internet Explorer HTML5 support
    wp_enqueue_script( 'html5hiv',get_template_directory_uri().'/inc/assets/js/html5.js', array(), '3.7.0', false );
    wp_script_add_data( 'html5hiv', 'conditional', 'lt IE 9' );

	// load bootstrap js
    wp_enqueue_script('wp-bootstrap-starter-popper', get_template_directory_uri() . '/inc/assets/js/popper.min.js', array() );
	wp_enqueue_script('wp-bootstrap-starter-bootstrapjs', get_template_directory_uri() . '/inc/assets/js/bootstrap.min.js', array() );
    wp_enqueue_script('wp-bootstrap-starter-themejs', get_template_directory_uri() . '/inc/assets/js/theme-script.js', array() );
	wp_enqueue_script( 'wp-bootstrap-starter-skip-link-focus-fix', get_template_directory_uri() . '/inc/assets/js/skip-link-focus-fix.js', array(), '20151215', true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'wp_bootstrap_starter_scripts' );


function wp_bootstrap_starter_password_form() {
    global $post;
    $label = 'pwbox-'.( empty( $post->ID ) ? rand() : $post->ID );
    $o = '<form action="' . esc_url( site_url( 'wp-login.php?action=postpass', 'login_post' ) ) . '" method="post">
    <div class="d-block mb-3">' . __( "To view this protected post, enter the password below:", "wp-bootstrap-starter" ) . '</div>
    <div class="form-group form-inline"><label for="' . $label . '" class="mr-2">' . __( "Password:", "wp-bootstrap-starter" ) . ' </label><input name="post_password" id="' . $label . '" type="password" size="20" maxlength="20" class="form-control mr-2" /> <input type="submit" name="Submit" value="' . esc_attr__( "Submit", "wp-bootstrap-starter" ) . '" class="btn btn-primary"/></div>
    </form>';
    return $o;
}
add_filter( 'the_password_form', 'wp_bootstrap_starter_password_form' );



/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Custom functions that act independently of the theme templates.
 */
require get_template_directory() . '/inc/extras.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load plugin compatibility file.
 */
require get_template_directory() . '/inc/plugin-compatibility/plugin-compatibility.php';

/**
 * Load custom WordPress nav walker.
 */
if ( ! class_exists( 'wp_bootstrap_navwalker' )) {
    require_once(get_template_directory() . '/inc/wp_bootstrap_navwalker.php');
}

// Custom excerpt length

function excerpt($limit) {
	$excerpt = explode(' ', get_the_content(), $limit);
	if (count($excerpt)>=$limit) {
		array_pop($excerpt);
		$excerpt = implode(" ",$excerpt).' ...';
	} else {
		$excerpt = implode(" ",$excerpt);
	}
	$excerpt = preg_replace('`\[[^\]]*\]`','',$excerpt);
	return $excerpt;
}
function bootstrap_pagination($query, $echo = true) {
	$big = 999999999; // need an unlikely integer
	$pages = paginate_links( array(
			'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
			'format' => '?paged=%#%',
			'current' => max( 1, get_query_var('paged') ),
			'total' => $query->max_num_pages,
			'type'  => 'array',
			'prev_next'   => true,
			'prev_text'    => '<i class="fa fa-angle-double-right" aria-hidden="true"></i>',
			'next_text'    => '<i class="fa fa-angle-double-left" aria-hidden="true"></i>'
		)
	);
	if( is_array( $pages ) ) {
		//$paged = ( get_query_var('paged') == 0 ) ? 1 : get_query_var('paged');

		$pagination = '<ul class="pagination">';

		foreach ( $pages as $page ) {
			$pagination .= "<li class='page-item'>$page</li>";
		}

		$pagination .= '</ul>';

		if ( $echo ) {
			echo $pagination;
		} else {
			return $pagination;
		}
	}
}
function wpschool_contact_scripts(){
	wp_register_script('ajax-contact-script', get_template_directory_uri() . '/ajax-contact-script.js', array('jquery') );
	wp_enqueue_script('ajax-contact-script');

	wp_localize_script( 'ajax-contact-script', 'ajax_contact_object', array(
		'ajax_url' => admin_url( 'admin-ajax.php' ),
		'loading_message' => pll__('در حال ارسال اطلاعات ، لطفا صبر کنید...')
	));
}
add_action('wp_enqueue_scripts', 'wpschool_contact_scripts');

function wpschool_ajax_contact(){
	$hasError = false;
	if (check_recaptcha() == false) {
		$message = pll__('روی عبارت من ربات نیستم کلیک کنید');
		$hasError = true;
	}
	if(trim($_POST['name']) === '') {
		$message = pll__('لطفا نام خود را وارد نمایید');
		$hasError = true;
	} else {
		$name = sanitize_text_field($_POST['name']);
	}
	if(trim($_POST['email']) === '')  {
		$message = pll__('لطفا آدرس ایمیل خود را وارد نمایید');
		$hasError = true;
	} else if (!preg_match("/^[[:alnum:]][a-z0-9_.-]*@[a-z0-9.-]+\.[a-z]{2,4}$/i", trim($_POST['email']))) {
		$message = pll__('آدرس ایمیل وارد شده صحیح نمی باشد');
		$hasError = true;
	} else {
		$email = sanitize_text_field($_POST['email']);
	}
	$phone = sanitize_text_field($_POST['phone']);
	$postalCode = sanitize_text_field($_POST['postalCode']);
	$companyName = sanitize_text_field($_POST['companyName']);
	if(trim($_POST['comment']) === '') {
		$message = pll__('لطفا پیام خود را وارد نمایید');
		$hasError = true;
	} else {
		$comment = esc_textarea($_POST['comment']);
	}
	if(!$hasError) {
		$emailTo = get_option('admin_email');
		$subject = 'یک پیغام از طرف '.$name;
		$body = "نام فرستنده: $name \n\nایمیل نویسنده: $email \n\nتلفن: $phone \n\nکدپستی: $postalCode \n\nنام شرکت: $companyName \n\nپیام: $comment";
		$headers = 'From: '.$name.' <'.$emailTo.'>' . "\r\n" . 'Reply-To: ' . $email;
		wp_mail($emailTo, $subject, $body, $headers);
		$message = pll__('پیام شما با موفقیت ارسال شد، با تشکر از شما');
	}
	echo json_encode(array('error'=>$hasError, 'message'=>$message));
	die();
}
add_action('wp_ajax_wpschool_ajax_contact', 'wpschool_ajax_contact');
add_action('wp_ajax_nopriv_wpschool_ajax_contact', 'wpschool_ajax_contact');
function theme_captcha() {
	if ( is_rtl() ) {
		wp_enqueue_script( 'recaptcha', 'https://www.google.com/recaptcha/api.js?hl=fa' );
	} else {
		wp_enqueue_script( 'recaptcha', 'https://www.google.com/recaptcha/api.js?hl=en' );
	}
}
add_action( 'wp_enqueue_scripts', 'theme_captcha' );
function check_recaptcha(){
	$recaptcha_secret = '6LfR9UcUAAAAAJDx817Jn7Dau6-rzkS7xVQlzaRp';
	$response = wp_remote_get("https://www.google.com/recaptcha/api/siteverify?secret=". $recaptcha_secret ."&response=". $_POST['g-recaptcha-response']);
	$response = json_decode($response["body"], true);
	if (true == $response["success"]) {
		return true;
	} else {
		return false;
	}
}

/* Home Page */
pll_register_string( 'راتین تجهیز البرز', 'راتین تجهیز البرز', 'Home' );
pll_register_string( 'تکنولوژی‌ها و راهکارهای شیت‌متال', 'تکنولوژی‌ها و راهکارهای شیت‌متال', 'Home' );
pll_register_string( 'لیزر', 'لیزر', 'Home' );
pll_register_string( 'پرس‌بریک', 'پرس‌بریک', 'Home' );
pll_register_string( 'گیوتین', 'گیوتین', 'Home' );
pll_register_string( 'نرم‌افزار', 'نرم‌افزار', 'Home' );
pll_register_string( 'بهتر امکان پذیر است', 'بهتر امکان پذیر است', 'Home' );
pll_register_string( 'خدمات ما', 'خدمات ما', 'Home' );
pll_register_string( 'به شما', 'به شما', 'Home' );
pll_register_string( 'ماشین‌های ورق‌کاری', 'ماشین‌های ورق‌کاری', 'Home' );
pll_register_string( 'قالب‌های پانچ سی‌ان‌سی', 'قالب‌های پانچ سی‌ان‌سی', 'Home' );
pll_register_string( 'قالب‌های پرس‌بریک', 'قالب‌های پرس‌بریک', 'Home' );
pll_register_string( 'نرم‌افزارهای ورق‌کاری', 'نرم‌افزارهای ورق‌کاری', 'Home' );
pll_register_string( 'مشاوره و آموزش', 'مشاوره و آموزش', 'Home' );
pll_register_string( 'توضیح ماشین‌های ورق‌کاری', 'با مشاوره، تامین و تجهیز خطوط تولیدی شما با ماشین‌های لیزر، پرس‌بریک و گیوتین در خدمت شما هستیم', 'Home', true );
pll_register_string( 'توضیح قالب‌های پانچ سی‌ان‌سی', 'در انتخاب، تامین و نگهداری از ابزارهای پانچتان در کنار شما هستیم', 'Home', true );
pll_register_string( 'توضیح قالب‌های پرس‌بریک', 'با مشاوره در انتخاب و تامین قالب‌های پرس‌بریک شما از برند معتبر اروپایی در خدمت شما هستیم', 'Home', true );
pll_register_string( 'توضیح نرم‌افزارهای ورق‌کاری', 'از 0 تا 100 ورق‌کاری را با نرم‌فزارهای lantek مدیریت کنید نرم‌افزارهای lantek manager نرم‌افزارهای برش لیزر، پلاسما، واترجت و هواگاز نرم افزار پانچ', 'Home', true );
pll_register_string( 'توضیح مشاوره و آموزش', 'مشاوره در بهینه‌سازی خطوط ورق‌کاری، مشاوره و آموزش در استفاده بهینه از ماشین آلات ورق‌کاری، آموزش لیزر، پانچ، پرس‌بریک و نرم افزار Lantek', 'Home', true );
pll_register_string( 'افتخار ما', 'افتخار ما', 'Home' );
pll_register_string( 'مشتریان ما', 'مشتریان ما', 'Home' );
pll_register_string( 'توضیح مشتریان ما', 'راتین تجهیز البرز افتخار همکاری با صنایع مختلفی را داشته و همواره به دنبال بدست آوردن عمیق ترین اعتماد مشتریان خود می باشد.', 'Home', true );
pll_register_string( 'مشاهده مشتریان ما', 'مشاهده مشتریان ما', 'Home' );
pll_register_string( 'شرکای', 'شرکای', 'Home' );
pll_register_string( 'تجاری', 'تجاری', 'Home' );
pll_register_string( 'شرکای تجاری', 'شرکای تجاری', 'Home' );
pll_register_string( 'مشاهده وبسایت', 'مشاهده وبسایت', 'Home' );
pll_register_string( 'چکیده مقالات', 'چکیده مقالات', 'Home' );
pll_register_string( 'مقالات', 'مقالات', 'Home' );
pll_register_string( 'مشاهده همه مقالات', 'مشاهده همه مقالات', 'Home' );
pll_register_string( 'مطالعه ادامه مقاله', 'مطالعه ادامه مقاله', 'Home' );

/* Footer Page */
pll_register_string( 'ارتباط با ما', 'ارتباط با ما', 'Footer' );
pll_register_string( 'نام شما:', 'نام شما:', 'Footer' );
pll_register_string( 'ایمیل شما:', 'ایمیل شما:', 'Footer' );
pll_register_string( 'تلفن شما:', 'تلفن شما:', 'Footer' );
pll_register_string( 'کد پستی:', 'کد پستی:', 'Footer' );
pll_register_string( 'نام شرکت شما:', 'نام شرکت شما:', 'Footer' );
pll_register_string( 'پیام شما:', 'پیام شما:', 'Footer' );
pll_register_string( 'ارسال پیام', 'ارسال پیام', 'Footer' );
pll_register_string( 'پیام شما با موفقیت ارسال شد، با تشکر از شما', 'پیام شما با موفقیت ارسال شد، با تشکر از شما', 'Footer', true );
pll_register_string( 'متاسفانه خطایی رخ داده است لطفا دوباره تلاش نمایید', 'متاسفانه خطایی رخ داده است لطفا دوباره تلاش نمایید', 'Footer', true );
pll_register_string( 'آدرس:', 'آدرس:', 'Footer' );
pll_register_string( 'توضیح آدرس', 'ونک، انتهای برزیل شرقی، بعد از دیوان محاسبات، کوی لاله، پلاک ۶، واحد ۳۰۲', 'Footer', true );
pll_register_string( 'تلفن:', 'تلفن:', 'Footer' );
pll_register_string( 'فکس:', 'فکس:', 'Footer' );
pll_register_string( 'لطفا نام خود را وارد نمایید', 'لطفا نام خود را وارد نمایید', 'Footer' );
pll_register_string( 'لطفا آدرس ایمیل خود را وارد نمایید', 'لطفا آدرس ایمیل خود را وارد نمایید', 'Footer' );
pll_register_string( 'آدرس ایمیل وارد شده صحیح نمی باشد', 'آدرس ایمیل وارد شده صحیح نمی باشد', 'Footer' );
pll_register_string( 'لطفا پیام خود را وارد نمایید', 'لطفا پیام خود را وارد نمایید', 'Footer' );
pll_register_string( 'روی عبارت من ربات نیستم کلیک کنید', 'روی عبارت من ربات نیستم کلیک کنید', 'Footer' );
pll_register_string( 'در حال ارسال اطلاعات ، لطفا صبر کنید...', 'در حال ارسال اطلاعات ، لطفا صبر کنید...', 'Footer' );

/* About Us Page */
pll_register_string( 'درباره شرکت راتین تجهیز البرز', 'درباره شرکت راتین تجهیز البرز', 'AboutUs' );
pll_register_string( 'شرکت راتین تجهیز البرز به منظور تامین و توزیع بهترین و با کیفیت ترین ماشین آلات، ابزارآلات و لوازم مصرفی صنعت ورقکاری با قیمتهایی رقابتی تاسیس گشت. این شرکت در حال حاضر با ارایه راهکارهای جامع جهت راه اندازی و بهینه سازی خطوط تولید شیت متال و تامین گستره وسیعی از ماشین آلات، قالبهای پانچ ، قالبهای پرس بریک ، لوازم مصرفی لیزر، لوازم مصرفی پلاسما و نرم افزار ماشن های پانچ / لیزر/پلاسما و واترجت را در حوزه فعالیت خود دارد.', 'شرکت راتین تجهیز البرز به منظور تامین و توزیع بهترین و با کیفیت ترین ماشین آلات، ابزارآلات و لوازم مصرفی صنعت ورقکاری با قیمتهایی رقابتی تاسیس گشت. این شرکت در حال حاضر با ارایه راهکارهای جامع جهت راه اندازی و بهینه سازی خطوط تولید شیت متال و تامین گستره وسیعی از ماشین آلات، قالبهای پانچ ، قالبهای پرس بریک ، لوازم مصرفی لیزر، لوازم مصرفی پلاسما و نرم افزار ماشن های پانچ / لیزر/پلاسما و واترجت را در حوزه فعالیت خود دارد.', 'AboutUs', true );
pll_register_string( 'راتین تجهیز البرز همواره در تلاش است تا رابطه ای محکم و بلند مدت با کلیه تامین کنندگان و مشتریان ایجاد نموده و آن را تقویت نماید به این دلیل راتین تجهیز البرز بیش از آن که به یکی از تامین کنندگان به چشم آید، شریکی ضروری برای مشتریان خود می باشد. ما با تمامی مشتریان بطوری نزدیک در حال همکاری هستیم تا به آنها نسبت به کیفیت ، خدمات پس از فروش و بهترین قیمتها اطمینان دهیم.', 'راتین تجهیز البرز همواره در تلاش است تا رابطه ای محکم و بلند مدت با کلیه تامین کنندگان و مشتریان ایجاد نموده و آن را تقویت نماید به این دلیل راتین تجهیز البرز بیش از آن که به یکی از تامین کنندگان به چشم آید، شریکی ضروری برای مشتریان خود می باشد. ما با تمامی مشتریان بطوری نزدیک در حال همکاری هستیم تا به آنها نسبت به کیفیت ، خدمات پس از فروش و بهترین قیمتها اطمینان دهیم.', 'AboutUs', true );
pll_register_string( 'مطمئنا شما نیز بدنبال راههایی برای کاهش هزینه و تولید محصولاتی با قیمت تمام شده پائینتر می باشید.در این میان افزایش بهره وری با استفادذه از ماشیت آلات دقیق و با کیفیت و نیز  کاهش هزینه های تامین ابزار آلات تولیدی و نیز افزایش کارایی و بهبود عملکرد آنها از اولویتهای هر شرکتی می باشد.', 'مطمئنا شما نیز بدنبال راههایی برای کاهش هزینه و تولید محصولاتی با قیمت تمام شده پائینتر می باشید.در این میان افزایش بهره وری با استفادذه از ماشیت آلات دقیق و با کیفیت و نیز  کاهش هزینه های تامین ابزار آلات تولیدی و نیز افزایش کارایی و بهبود عملکرد آنها از اولویتهای هر شرکتی می باشد.', 'AboutUs', true );
pll_register_string( 'راتین تجهیز البرز با معرفی محصولات:', 'راتین تجهیز البرز با معرفی محصولات:', 'AboutUs', true );
pll_register_string( 'Adira,Parma stamp,Mora,Ciemmegi ,Lantek', 'Adira,Parma stamp,Mora,Ciemmegi ,Lantek', 'AboutUs', true );
pll_register_string( 'به شما اطمینان میدهد، محصولات ارائه شده با کیفیتی برتر از سایر تامین کنندگان و نیز ارائه قیمتهایی منصفانه، شما را در بر داشتن گامی محکم جهت کاهش هزینه و افزایش بهره وری یاری نماید.', 'به شما اطمینان میدهد، محصولات ارائه شده با کیفیتی برتر از سایر تامین کنندگان و نیز ارائه قیمتهایی منصفانه، شما را در بر داشتن گامی محکم جهت کاهش هزینه و افزایش بهره وری یاری نماید.', 'AboutUs', true );

/* After Sales Service Page */
pll_register_string( 'خدمات پس از فروش', 'خدمات پس از فروش', 'AfterSalesService' );
pll_register_string( 'با توجه به اهمیت و نقش خدمات پس از فروش در تامین رضایت مشتریان ارجمند و نیز رفع دغدغه صنعتگران عزیز،  در جهت ارائه خدمات مطلوبتر و حرفه ای تر و همچنین پشتیبانی همه جانبه از صنعتگران حوزه ورقکاری، طی تصمیم  هیات مدیره شرکت راتین تجهیز البرز ، این ماموریت به شرکت آریا صنعت البرز سازان بعنوان بخشی از گروه صنعتی راتین تجهیز که پیشینه، مهارت و تجریبات ارزنده ای در نصب، تعمیرات و نگهداری در صنایع مختلف دارد ، محول گردید.', 'با توجه به اهمیت و نقش خدمات پس از فروش در تامین رضایت مشتریان ارجمند و نیز رفع دغدغه صنعتگران عزیز،  در جهت ارائه خدمات مطلوبتر و حرفه ای تر و همچنین پشتیبانی همه جانبه از صنعتگران حوزه ورقکاری، طی تصمیم  هیات مدیره شرکت راتین تجهیز البرز ، این ماموریت به شرکت آریا صنعت البرز سازان بعنوان بخشی از گروه صنعتی راتین تجهیز که پیشینه، مهارت و تجریبات ارزنده ای در نصب، تعمیرات و نگهداری در صنایع مختلف دارد ، محول گردید.', 'AfterSalesService', true );
pll_register_string( 'شرکت آریا صنعت البرز سازان، امیدوار است  با تکیه  بر تجارب صنعتی، تیم حرفه ای با مهارتهای متنوع و کارنامه موفق در زمینه ی همکاری با شرکتهای بزرگی همچون توربین گاز مپنا (توگا ) ، سیمان آبیک ، برنز و .... بتواند  گامی بزرگ در جهت  ارائه خدمات مطلوبتر و سریع تر را بردارد . جهت آشنایی با  فعالیت های  شرکت آریا صنعت  البرز سازان  به سایت <a href="http://www.aryasas.com/" target="_blank">www.aryasas.com</a> مراجعه فرمایید.', 'شرکت آریا صنعت البرز سازان، امیدوار است  با تکیه  بر تجارب صنعتی، تیم حرفه ای با مهارتهای متنوع و کارنامه موفق در زمینه ی همکاری با شرکتهای بزرگی همچون توربین گاز مپنا (توگا ) ، سیمان آبیک ، برنز و .... بتواند  گامی بزرگ در جهت  ارائه خدمات مطلوبتر و سریع تر را بردارد . جهت آشنایی با  فعالیت های  شرکت آریا صنعت  البرز سازان  به سایت <a href="http://www.aryasas.com/" target="_blank">www.aryasas.com</a> مراجعه فرمایید.', 'AfterSalesService', true );

/* Coming Soon Page */
pll_register_string( 'این صفحه در حال ساخت است و بزودی در دسترس قرار می گیرد', 'این صفحه در حال ساخت است و بزودی در دسترس قرار می گیرد', 'ComingSoon' );

/* Software Page */
pll_register_string( 'نرم‌افزارهای ورق‌کاری', 'نرم‌افزارهای ورق‌کاری', 'Software' );
pll_register_string( 'آیا می‌دانید راتین تجهیز البرز نماینده انحصاری لنتک در ایران است؟', 'آیا می‌دانید راتین تجهیز البرز نماینده انحصاری لنتک در ایران است؟', 'Software' );
pll_register_string( 'درباره‌ لنتک', 'درباره‌ لنتک', 'Software' );
pll_register_string( 'توضیح اول درباره لنتک', 'لنتک یک شرکت جهانی با رویکرد محلی می باشد. لنتک می خواهد نزدیک مشتریان و شرکای خود بوده، نیازهای آنها را بدون واسطه بشناسد و با داشتن یک رابطه نزدیک و دست در دست آنها برای یافتن بهترین راه حل به منظور بهبود بهره وری و کارآمدی آنها اقدام نماید.', 'Software', true );
pll_register_string( 'توضیح دوم درباره لنتک', 'لنتک بهترین مشورت ممکن، گسترده ترین طیف محصولات و بهترین تیم متخصصان را ارائه می کند که آماده ی رویارویی با هر سناریویی در زمینه ماشین در بخش شیت متال و ساختارهای استیل می باشند.', 'Software', true );
pll_register_string( 'توضیح سوم درباره لنتک', 'لنتک قادر است تا یک راه حل نرم افزاری کامل را صرف نظر از بخشی که شرکت شما به آن تعلق دارد، برای تولید فلزتان ارائه دهد.', 'Software', true );
pll_register_string( 'توضیح چهارم درباره لنتک', 'لنتک به صورت موثر با تمامی ماشین آلات موجود شیت متال، تیوب یا اشعه همکاری نموده و به بیشترین بازدهی و عملکرد دست می یابد.', 'Software', true );

/* Ciemmegi Page */
pll_register_string( 'ابزارهای پانچ استاندارد و خاص', 'ابزارهای پانچ استاندارد و خاص', 'Ciemmegi' );
pll_register_string( 'کلیه ماشین آلات شامل', 'کلیه ماشین آلات شامل', 'Ciemmegi' );
pll_register_string( 'ابزارهای مالتی تول سازگار با', 'ابزارهای مالتی تول سازگار با', 'Ciemmegi' );
pll_register_string( 'نمونه ای از مالتی تول ها', 'نمونه ای از مالتی تول ها', 'Ciemmegi' );
pll_register_string( 'ابزارهای سازگار با سایر تولیدکنندگان', 'ابزارهای سازگار با سایر تولیدکنندگان', 'Ciemmegi' );
pll_register_string( 'ابزارهای Thick turret', 'ابزارهای Thick turret', 'Ciemmegi' );
pll_register_string( 'ابزارهای فرم خاص و استاندارد صنایع مختلف', 'ابزارهای فرم خاص و استاندارد صنایع مختلف', 'Ciemmegi' );
pll_register_string( 'ابزارهای الاین کردن دستگاه پانچ ( Alignment tools)', 'ابزارهای الاین کردن دستگاه پانچ ( Alignment tools)', 'Ciemmegi' );
pll_register_string( 'توضیح ابزارهای الاین کردن', 'با توجه به حساسیت دستگاههای پانچ، نگهداری پیشگیرانه از دستگاه جهت الاین بودن تارت بالا نسبت به تارت پایین به منظور حفظ طول عمر مفید ابزار، کیفیت پانچکاری و نیز کاهش استهلاک ماشین از ضروریات است. شما می توانید با تهیه ابزارآلات مربوط به آلاین کردن نسبت به این موضوع اقدام نمایید.', 'Ciemmegi', true );
pll_register_string( 'ابزار الاین کردن', 'ابزار الاین کردن', 'Ciemmegi' );
pll_register_string( 'نمونه کارها', 'نمونه کارها', 'Ciemmegi' );
pll_register_string( 'فرم ایجاد شده با ارتفاع 10 میلیمتر بر روی ورق استنلس استیل 304 با ضخامت 2 میلیمتر', 'فرم ایجاد شده با ارتفاع 10 میلیمتر بر روی ورق استنلس استیل 304 با ضخامت 2 میلیمتر', 'Ciemmegi' );
pll_register_string( 'ابزار لولا بر روی ورق 1 میلیمتر استنلس استیل', 'ابزار لولا بر روی ورق 1 میلیمتر استنلس استیل', 'Ciemmegi' );
pll_register_string( 'شرکت راتین تجهیز البرز، تامین کننده ابزارآلات ساخت شرکت Mate precision tooling  آمریکا نیز می باشد.', 'شرکت راتین تجهیز البرز، تامین کننده ابزارآلات ساخت شرکت Mate precision tooling  آمریکا نیز می باشد.', 'Ciemmegi' );
pll_register_string( 'درباره‌ Ciemmegi', 'درباره‌ Ciemmegi', 'Ciemmegi' );
pll_register_string( 'Ciemmegi برای موارد زیر سنبه و ماتریس تولید می نماید:', 'Ciemmegi برای موارد زیر سنبه و ماتریس تولید می نماید:', 'Ciemmegi' );
pll_register_string( 'برش های پانچ', 'برش های پانچ', 'Ciemmegi' );
pll_register_string( 'خطوط پانچ', 'خطوط پانچ', 'Ciemmegi' );
pll_register_string( 'ماشین های پانچ شیت متال (دستی و CNC)', 'ماشین های پانچ شیت متال (دستی و CNC)', 'Ciemmegi' );
pll_register_string( 'توضیح درباره اول', 'شرکت ciemmegi با 40 سال تجربه ی مستمر و به لطف سرمایه گذاری های تحقیقاتی و فناوری، در موقعیتی قرار دارد که برای هر گونه مشکل پانچ، راه حلی ارائه کند. در حیطه ماشین های پانچ دستی و CNC شیت متال، Ciemmegi راه حلی را ارتقاء داده است که دوره های فرآیند را بهینه نموده و بنابراین می تواند با بررسی طراحی قطعات مورد نیاز برای ساخت، ابزار را تامین نماید. در حوزه ی خطوط پانچ کارهای ساختاری استیل، Ciemmegi به اهداف مهمی در زمینه ی انتخاب مواد و عملیات حرارتی دست یافته که امکان اجرای انواع پانچکاری  ای که در سال های نه چندان دور غیر ممکن در نظر گرفته می شدند را می دهد.', 'Ciemmegi', true );
pll_register_string( 'توضیح درباره دوم', 'شرکت ما از نظر فناوری پیشرفته بوده و تنوع وسیعی از ابزارهای استاندارد که می توانند هر گونه شکلی را به لطف سیستم CAD/CAM ایجاد کنند، دارا می باشد، بنابراین محصولات ما دقیقا برای تایید نهایی مشتریان تولید شده و با بیشترین دقت به سخت ترین نیازها پاسخ می دهند.', 'Ciemmegi', true );

/* Parma Stamp Page */
pll_register_string( 'ابزار‌های پرس‌بریک', 'ابزار‌های پرس‌بریک', 'ParmaStamp' );
pll_register_string( 'ابزار پرس‌بریک استاندارد', 'ابزار پرس‌بریک استاندارد', 'ParmaStamp' );
pll_register_string( 'توضیح اول استاندارد', 'محصولات Parma Stamp از آنجا که از نظر کیفی در مقایسه با رقبا از نظر خصوصیات فنی، مواد اولیه، استحکام و دقت برتر هستند، در جایگاه نخست بازار قرار دارند. تولیدکنندگان شناخته شده ی پرس بریک های هیدرولیک توسط Parma Stamp در زمینه ابزار استاندارد و خاص تجهیز می شوند.', 'ParmaStamp', true );
pll_register_string( 'توضیح دوم استاندارد', 'ابزار Parma Stamp نه تنها در سطوح کاری بلکه در پیوست و سایر قسمت ها زمین می شوند که باعث یکنواختی زیبایی می گردد و تقارن، چهارگوش، مرکز و تراز بودن قالب حاصل شود. دقت تلورانس 0.01mm برای تعویض پدیری کامل گارانتی محصولات استاندارد Parma Stamp در زمان عرضه می باشد. شماره محصول، حداکثر بار و طول ابزار Parma Stamp برای تشخیص راحت کالا و در تطابق با استانداردهای ایمنی کار اروپا، توسط لیزر علامت گذاری شده است.', 'ParmaStamp', true );
pll_register_string( 'ابزار پرس‌بریک خاص', 'ابزار پرس‌بریک خاص', 'ParmaStamp' );
pll_register_string( 'توضیح اول خاص', 'Parma Stamp نه تنها در طراحی و تولید همه نوع ابزار پرس بریک متخصص است، بلکه می تواند خطوط کامل ابزار برای ماشین های خمکاری پنل و مراکز خمکاری را به صورت کاملا مقاوم و با تلورانس 0.01mm عرضه نماید. عملیات حرارتی بر طبق نیازهای مختلف دوام و قدرت تعیین می شود که پیشرفته ترین راه حل فنی را به مشتریانمان با توجه به بودجه سرمایه گذاریشان توصیه می کنیم.', 'ParmaStamp', true );
pll_register_string( 'توضیح دوم خاص', 'دپارتمان مهندسی Parma Stamp به دقت اندازه، استحکام و حداکثر بار ابزار را به وسیله ی نرم افزار رسم 3 بعدی و روش المان محدود اندازه گیری می نماید. بررسی ها تجهیزات موجود را در محیط کاری که وسیله در آن قرار می گیرد، در نظر می گیرند. پس از آزمایش در کارگاه Parma Stamp و اغلب بعد از تایید یک نمونه خم شیت متال، ابزار خاص برای مشتری ارسال می گردد بنابراین مشتری می تواند بدون فوت وقت نسبت به استفاده از ابزار اقدام نماید.', 'ParmaStamp', true );
pll_register_string( 'ابزار ماشین‌های خمکاری', 'ابزار ماشین‌های خمکاری', 'ParmaStamp' );
pll_register_string( 'تضیح اول خمکاری', 'ما می توانیم ابزار و تیغه ها را برای هر نوع ماشین پنل بندر تغییر دهیم: Codatto Trumpf, RAS, Weinbrenner Schroeder, Fasti, Schechtel, EHT, Jordi و غیره. Parma Stamp اصلاح سطوح، تیز کردن لبه ها و عملیات حرارتی را انجام می دهد.', 'ParmaStamp', true );
pll_register_string( 'توضیح دوم خمکاری', 'ابزار Parma Stamp بر طبق ویژگی های فنی مختلف ماشین یا ورق، دارای سختکاری موضعی، سختکاری القائی یا سختکاری با نیتروژن، سندبلاست شده و زمین شده، می باشد. Parma Stamp می تواند به مشتریانش بهترین راه حل را برای هر نیاز منفرد توصیه کند.', 'ParmaStamp', true );
pll_register_string( 'قطعات یدکی', 'قطعات یدکی', 'ParmaStamp' );
pll_register_string( 'توضیح اول یدکی', 'به لطف تعداد بالای ابزار پیش ساخته برای ماشین های خم و پنل بندر مانندWEINBRENNER, RAS, SALVAGNINI, CODATTO و سایر ماشین ها، Parma Stamp قادر است قطعات یدکی یا مجموعه ابزار را طراحی و تولید نماید.', 'ParmaStamp', true );
pll_register_string( 'توضیح دوم یدکی', 'Parma Stamp می تواند خطوط کامل پایین نگهدارنده ها، قسمت های میانی و قطعات منفرد را جایگزین نموده یا می تواند مجموعه موجود را با ماشینکاری عالی مانند حالت اولش تیز نماید. ابزار Parma Stamp بر طبق ویژگی های فنی مختلف ماشین یا ورق، دارای سختکاری موضعی، سختکاری القائی یا سختکاری با نیتروژن، می باشد. به دلیل همکاری با یک شرکت خدمات پس از فروش مجزا،Parma Stamp می تواند نصب، نگهداری و پشتیبانی نرم افزاری را ارائه نماید.', 'ParmaStamp', true );
pll_register_string( 'کاتالوگ ها', 'کاتالوگ ها', 'ParmaStamp' );
pll_register_string( 'درباره‌ Parma Stamp', 'درباره‌ Parma Stamp', 'ParmaStamp' );
pll_register_string( 'توضیح اول درباره', 'Parma Stamp از سال 1974 تاکنون در زمینه ی تولید ابزار پرس بریک استاندارد و خاص فعالیت داشته و توانسته در میان مشتریانش به عنوان معتبرترین شرکت جهان شناخته شود. محصولات Parmastamp از آنجا که از نظر کیفی در مقایسه با رقبا از نظر خصوصیات فنی، مواد اولیه، استحکام و دقت برتر هستند، در جایگاه نخست بازار قرار دارند. شرکت های معتبری که ماشین آلات خمکاری شیت متال را تولید می کنند، مدت هاست که تجهیزات استاندارد و خاص خود را از این شرکت تهیه می کنند.', 'ParmaStamp', true );
pll_register_string( 'توضیح دوم درباره', 'Parma Stamp نه تنها در طراحی و تولید همه نوع ابزار پرس بریک متخصص است، بلکه می تواند خطوط کامل ابزار برای ماشین های خمکاری پنل و مراکز خمکاری را به صورت کاملا مقاوم و با تلورانس 0.01mm عرضه نماید.', 'ParmaStamp', true );
pll_register_string( 'توضیح سوم درباره', 'ابزارهای  این شرکت در صنایع مختلف مانند تولید کنندگان ماشین آلات، پیمانکاران، ساخت و سازهای شهری، مبلمان فلزی، فرم های در، وسایل نقلیه، هوانوردی، آسانسور، ساخت کشتی، ریل راه آهن، قطب های رعد و برق و بسیاری دیگر به کار می روند.', 'ParmaStamp', true  );
pll_register_string( 'توضیح سوم درباره', 'محصولات این شرکت امروزه در شرکت های بزرگ و کوچک جهان مانند FRANKE، RITTAL، KARDEX، RANNILA، SCHMITZ CARGO BULL، MAN، CANADAIR، URAL VAGON، ZAVOD، LIEBHERR، PISCINE CASTIGLIONE GROUP A&T که تعداد کمی از آنها هستند، نصب شده است.', 'ParmaStamp', true );

/* Adira Page */
pll_register_string( 'ماشین‌های ورق‌کاری', 'ماشین‌های ورق‌کاری', 'Adira' );
pll_register_string( 'اطلاعات بیشتر...', 'اطلاعات بیشتر...', 'Adira' );
pll_register_string( 'درباره‌ Adira', 'درباره‌ Adira', 'Adira' );
pll_register_string( 'Adira بیش از 60 سال است که به طراحی، توسعه، تولید و نصب مدرن ترین ماشین آلات مشغول است.', 'Adira بیش از 60 سال است که به طراحی، توسعه، تولید و نصب مدرن ترین ماشین آلات مشغول است.', 'Adira' );
pll_register_string( 'سرمایه گذاری مداوم در تحقیقات علمی و توسعه فناوری به منظور ارائه ی همیشگی بهترین راه حل ها', 'سرمایه گذاری مداوم در تحقیقات علمی و توسعه فناوری به منظور ارائه ی همیشگی بهترین راه حل ها', 'Adira' );
pll_register_string( 'همکاری با دانشگاه ها و آزمایشگاه های مشهور تحقیقاتی', 'همکاری با دانشگاه ها و آزمایشگاه های مشهور تحقیقاتی', 'Adira' );
pll_register_string( 'کیفیت، دقت و قابلیت اطمینان راه حل های ما', 'کیفیت، دقت و قابلیت اطمینان راه حل های ما', 'Adira' );
pll_register_string( 'حداکثر عملکرد محصولات ما', 'حداکثر عملکرد محصولات ما', 'Adira' );
pll_register_string( 'آمادگی و کارآمدی خدمات پس از فروش', 'آمادگی و کارآمدی خدمات پس از فروش', 'Adira' );
pll_register_string( 'صادرات به بیش از 40 کشور جهان', 'صادرات به بیش از 40 کشور جهان', 'Adira' );
pll_register_string( 'بیش از 80% گردش مالی ما خارج از کشور خود (پرتغال)', 'بیش از 80% گردش مالی ما خارج از کشور خود (پرتغال)', 'Adira' );
pll_register_string( 'بیشترین سهم بازار در کشور خود', 'بیشترین سهم بازار در کشور خود', 'Adira' );
pll_register_string( 'تولید در دو کارخانه تولیدی با 15000 متر مربع', 'تولید در دو کارخانه تولیدی با 15000 متر مربع', 'Adira' );

/* Press Brakes Page */
pll_register_string( 'پرس‌بریک‌ها', 'پرس‌بریک‌ها', 'PressBrakes' );
pll_register_string( 'توضیح پرس بریک', 'تنوع وسیعی از پرس بریک ها، تمام نیازهای خم متداول و همچنین پروژه های خم به صورت سفارشی طراحی شده را پوشش می دهد. اگر نیاز شما از این هم فراتر رفت، Adira راه حل هایی دارد که می تواند آنها را برطرف نماید.', 'PressBrakes',true );
pll_register_string( 'تکنولوژی Hexa-C', 'تکنولوژی Hexa-C', 'PressBrakes' );
pll_register_string( 'PM Guimadira', 'PM Guimadira', 'PressBrakes' );
pll_register_string( 'Hydraulic Series', 'Hydraulic Series', 'PressBrakes' );
pll_register_string( 'بهترین نسبت قیمت به کیفیت', 'بهترین نسبت قیمت به کیفیت', 'PressBrakes' );
pll_register_string( '5 مدل استاندارد: 135، 160 و 220 تن', '5 مدل استاندارد: 135، 160 و 220 تن', 'PressBrakes' );
pll_register_string( 'در دو اندازه : 3 و 4 متری', 'در دو اندازه : 3 و 4 متری', 'PressBrakes' );
pll_register_string( 'سیستم ایمنی لیزر CE پیشرفته', 'سیستم ایمنی لیزر CE پیشرفته', 'PressBrakes' );
pll_register_string( 'سهولت در استفاده', 'سهولت در استفاده', 'PressBrakes' );
pll_register_string( 'راه حل اثبات شده', 'راه حل اثبات شده', 'PressBrakes' );
pll_register_string( 'طراحی و تولید شده در اروپا', 'طراحی و تولید شده در اروپا', 'PressBrakes' );
pll_register_string( 'استانداردهای کیفی بالا', 'استانداردهای کیفی بالا', 'PressBrakes' );
pll_register_string( 'قیمت رقابتی', 'قیمت رقابتی', 'PressBrakes' );
pll_register_string( 'دانلود کاتالوگ', 'دانلود کاتالوگ', 'PressBrakes' );

pll_register_string( 'PA Hexa C®', 'PA Hexa C®', 'PressBrakes' );
pll_register_string( 'Semi Hybrid', 'Semi Hybrid', 'PressBrakes' );
pll_register_string( 'جدیدترین تکنولوژی خمکاری', 'جدیدترین تکنولوژی خمکاری', 'PressBrakes' );
pll_register_string( 'دقیق', 'دقیق', 'PressBrakes' );
pll_register_string( 'سریع', 'سریع', 'PressBrakes' );
pll_register_string( 'پایدار', 'پایدار', 'PressBrakes' );
pll_register_string( 'انعطاف پذیر', 'انعطاف پذیر', 'PressBrakes' );

pll_register_string( 'PF سریع', 'PF سریع', 'PressBrakes' );
pll_register_string( 'Full Hybrid', 'Full Hybrid', 'PressBrakes' );
pll_register_string( 'در بالاترین رده پرس بریک ها', 'در بالاترین رده پرس بریک ها', 'PressBrakes' );
pll_register_string( 'سرعت بارگذاری، خمکاری و بازگشت بالا', 'سرعت بارگذاری، خمکاری و بازگشت بالا', 'PressBrakes' );
pll_register_string( 'دهانه عریض و کورس وسیع', 'دهانه عریض و کورس وسیع', 'PressBrakes' );
pll_register_string( 'عملکرد بالا', 'عملکرد بالا', 'PressBrakes' );
pll_register_string( 'تغییر سرعت تنها 2mm بالای صفحه', 'تغییر سرعت تنها 2mm بالای صفحه', 'PressBrakes' );
pll_register_string( 'نهایت دقت', 'نهایت دقت', 'PressBrakes' );
pll_register_string( 'بهترین مثال نوآوری و تکنولوژی در خمکاری', 'بهترین مثال نوآوری و تکنولوژی در خمکاری', 'PressBrakes' );
pll_register_string( 'ابزار انعطاف پذیر و گزینه های با کارآمدی بالا', 'ابزار انعطاف پذیر و گزینه های با کارآمدی بالا', 'PressBrakes' );
pll_register_string( 'ارگونومی، طراحی و ایمنی', 'ارگونومی، طراحی و ایمنی', 'PressBrakes' );
pll_register_string( 'ماشین ایده آل برای یکپارچه سازی با سلول های روباتیک', 'ماشین ایده آل برای یکپارچه سازی با سلول های روباتیک', 'PressBrakes' );
pll_register_string( 'بهترین انتخاب برای حداکثر عملکرد', 'بهترین انتخاب برای حداکثر عملکرد', 'PressBrakes' );

pll_register_string( 'GreenBender', 'GreenBender', 'PressBrakes' );
pll_register_string( 'Full Hybrid H-Frame', 'Full Hybrid H-Frame', 'PressBrakes' );
pll_register_string( 'تکنولوژی خمکاری هایبرید', 'تکنولوژی خمکاری هایبرید', 'PressBrakes' );
pll_register_string( 'خلاقیت', 'خلاقیت', 'PressBrakes' );
pll_register_string( 'دوستدار محیط زیست', 'دوستدار محیط زیست', 'PressBrakes' );
pll_register_string( 'دقت خارق العاده', 'دقت خارق العاده', 'PressBrakes' );
pll_register_string( 'تکنولوژی گرین داینامیک  هایبرید', 'تکنولوژی گرین داینامیک  هایبرید', 'PressBrakes' );
pll_register_string( 'تعمیر و نگهداری حداقل', 'تعمیر و نگهداری حداقل', 'PressBrakes' );
pll_register_string( 'انتخاب ایده آل برای مشتریان قرن 21', 'انتخاب ایده آل برای مشتریان قرن 21', 'PressBrakes' );

pll_register_string( 'Bluebender', 'Bluebender', 'PressBrakes' );
pll_register_string( 'Full Electrical', 'Full Electrical', 'PressBrakes' );
pll_register_string( 'پرس بریک الکتریکی', 'پرس بریک الکتریکی', 'PressBrakes' );
pll_register_string( 'تکنولوژی پایدار', 'تکنولوژی پایدار', 'PressBrakes' );
pll_register_string( 'ماشین بدون آلودگی', 'ماشین بدون آلودگی', 'PressBrakes' );

pll_register_string( 'PH مخصوص کارهای سنگین', 'PH مخصوص کارهای سنگین', 'PressBrakes' );
pll_register_string( 'پرس بریک های سایز بزرگ', 'پرس بریک های سایز بزرگ', 'PressBrakes' );
pll_register_string( 'ماشین های تناژ بالا', 'ماشین های تناژ بالا', 'PressBrakes' );
pll_register_string( 'طول خمکاری زیاد', 'طول خمکاری زیاد', 'PressBrakes' );
pll_register_string( 'راهکار تاندم', 'راهکار تاندم', 'PressBrakes' );
pll_register_string( 'کاملا قابل سفارشی سازی', 'کاملا قابل سفارشی سازی', 'PressBrakes' );
pll_register_string( 'استحکام، قابلیت اطمینان و ایمنی', 'استحکام، قابلیت اطمینان و ایمنی', 'PressBrakes' );
pll_register_string( 'انتخاب ایده آل برای وظایف سنگین', 'انتخاب ایده آل برای وظایف سنگین', 'PressBrakes' );

pll_register_string( 'سلول های خمکاری (Bending Cell)', 'سلول های خمکاری (Bending Cell)', 'PressBrakes' );
pll_register_string( 'راه حل های به صورت سفارشی طراحی شده', 'راه حل های به صورت سفارشی طراحی شده', 'PressBrakes' );
pll_register_string( 'سیستم تولید اتوماتیک', 'سیستم تولید اتوماتیک', 'PressBrakes' );
pll_register_string( 'حداکثر بهره وری', 'حداکثر بهره وری', 'PressBrakes' );
pll_register_string( 'دقت و تکرارپذیری خمکاری عالی', 'دقت و تکرارپذیری خمکاری عالی', 'PressBrakes' );
pll_register_string( 'عملیات مداوم', 'عملیات مداوم', 'PressBrakes' );
pll_register_string( 'راه حل های دردسترس', 'راه حل های دردسترس', 'PressBrakes' );

pll_register_string( 'راه حل های سفارشی', 'راه حل های سفارشی', 'PressBrakes' );
pll_register_string( 'راه حل های منحصر به فرد برای نیازهای خاص', 'راه حل های منحصر به فرد برای نیازهای خاص', 'PressBrakes' );
pll_register_string( 'پروژه برای نیازهای خاص شما طراحی می گردد', 'پروژه برای نیازهای خاص شما طراحی می گردد', 'PressBrakes' );
pll_register_string( 'برای اندازه های بزرگ و ضخامت های زیاد', 'برای اندازه های بزرگ و ضخامت های زیاد', 'PressBrakes' );
pll_register_string( 'پشتیبانی فنی عالی', 'پشتیبانی فنی عالی', 'PressBrakes' );
pll_register_string( 'تیم توسعه و مدیریت Adira در خدمت شما', 'تیم توسعه و مدیریت Adira در خدمت شما', 'PressBrakes' );
pll_register_string( 'نتایج عالی تجربه ی فنی طولانی تولیدات Adira', 'نتایج عالی تجربه ی فنی طولانی تولیدات Adira', 'PressBrakes' );

/* Laser Page */
pll_register_string( 'لیزر', 'لیزر', 'Laser' );
pll_register_string( 'توضیح لیزر', 'بیش از 10 سال است که Adira ماشین های برش لیزر را با موفقیت تولید می کند. این محصولات شامل موارد زیر می باشد: ماشین LE سطح استاندارد برای گستره ی وسیعی از کاربردها، ماشین LP کلاسیک با موتورهای خطی و عملکرد بالا در تمامی موقعیت ها، ماشین LF با یک لیزر فایبر نوین که به صورت ایده آل برای صفحات نازک و مواد صیقلی با مصرف و تعمیر و نگهداری پایین طراحی شده است. تمام ماشین های لیزر Adira، قابلیت اطمینان، دقت و عملکرد بالا را در برش فلز ارائه می دهند.', 'Laser', true );
pll_register_string( 'LE کارآمد', 'LE کارآمد', 'Laser' );
pll_register_string( 'سطح استاندارد برش لیزر', 'سطح استاندارد برش لیزر', 'Laser' );
pll_register_string( 'سیستم حرکت rack & pinion به شدت دقیق', 'سیستم حرکت rack & pinion به شدت دقیق', 'Laser' );
pll_register_string( 'عرض 3 متری گانتری با میز برش قابل گسترش', 'عرض 3 متری گانتری با میز برش قابل گسترش', 'Laser' );
pll_register_string( 'پیکربندی انعطاف پذیر', 'پیکربندی انعطاف پذیر', 'Laser' );
pll_register_string( 'بهترین کیفیت، تطبیق پذیری و نسبت قیمت', 'بهترین کیفیت، تطبیق پذیری و نسبت قیمت', 'Laser' );
pll_register_string( 'قیمت رقابتی', 'قیمت رقابتی', 'Laser' );

pll_register_string( 'LP فوق العاده', 'LP فوق العاده', 'Laser' );
pll_register_string( 'یک لیزر CO2 نوع SLAB با تعمیر و نگهداری پایین', 'یک لیزر CO2 نوع SLAB با تعمیر و نگهداری پایین', 'Laser' );
pll_register_string( 'سرعت جابه جایی بالا به دلیل موتور linear', 'سرعت جابه جایی بالا به دلیل موتور linear', 'Laser' );
pll_register_string( 'بهره وری بالا', 'بهره وری بالا', 'Laser' );
pll_register_string( 'کارایی برتر سورس لیزر: لیزر SLAB 2.5KW ورق کربن استیل تا 20mm را برش می دهد', 'کارایی برتر سورس لیزر: لیزر SLAB 2.5KW ورق کربن استیل تا 20mm را برش می دهد', 'Laser' );
pll_register_string( 'قطعات عالی: موتورهای خطی و سورس لیزر کیفیت بالا', 'قطعات عالی: موتورهای خطی و سورس لیزر کیفیت بالا', 'Laser' );
pll_register_string( 'LF فایبر', 'LF فایبر', 'Laser' );
pll_register_string( 'ترکیب ایده آل بهره وری بالا و تطبیق پذیری', 'ترکیب ایده آل بهره وری بالا و تطبیق پذیری', 'Laser' );
pll_register_string( 'لیزر فایبر، برتری تکنولوژی در سطح جهانی', 'لیزر فایبر، برتری تکنولوژی در سطح جهانی', 'Laser' );
pll_register_string( 'مصرف الکتریکی پایین', 'مصرف الکتریکی پایین', 'Laser' );
pll_register_string( 'تعمیر و نگهداری کم (سورس لیزر بدون نیاز به نگهداری، موتور خطی با نگهداری پایین و لنز محافظت شده با شیشه)', 'تعمیر و نگهداری کم (سورس لیزر بدون نیاز به نگهداری، موتور خطی با نگهداری پایین و لنز محافظت شده با شیشه)', 'Laser' );
pll_register_string( 'مصرف گاز پایین (سورس لیزر به گاز نیاز ندارد)', 'مصرف گاز پایین (سورس لیزر به گاز نیاز ندارد)', 'Laser' );
pll_register_string( 'تکنولوژی بهینه برای برش مواد صیقلی', 'تکنولوژی بهینه برای برش مواد صیقلی', 'Laser' );
pll_register_string( 'انتخاب ایده آل برای صغحات نازک', 'انتخاب ایده آل برای صغحات نازک', 'Laser' );
pll_register_string( 'سرعت جابه جایی بالا توسط موتورهای خطی', 'سرعت جابه جایی بالا توسط موتورهای خطی', 'Laser' );
pll_register_string( 'سرعت برش غیر قابل رقابت', 'سرعت برش غیر قابل رقابت', 'Laser' );

pll_register_string( 'Blue Laser', 'Blue Laser', 'Laser' );
pll_register_string( 'سیستم حرکت rack & pinion به شدت دقیق', 'سیستم حرکت rack & pinion به شدت دقیق', 'Laser' );
pll_register_string( 'مصرف الکتریکی پایین', 'مصرف الکتریکی پایین', 'Laser' );
pll_register_string( 'مصرف گاز پایین، تنها برش نیاز به گاز دارد', 'مصرف گاز پایین، تنها برش نیاز به گاز دارد', 'Laser' );
pll_register_string( 'تکنولوژی بهینه برای برش مواد صیقلی', 'تکنولوژی بهینه برای برش مواد صیقلی', 'Laser' );
pll_register_string( 'انتخاب ایده آل برای صغحات نازک', 'انتخاب ایده آل برای صغحات نازک', 'Laser' );
pll_register_string( 'سرعت برش غیر قابل رقابت', 'سرعت برش غیر قابل رقابت', 'Laser' );
pll_register_string( 'بهترین کیفیت، تطبیق پذیری و نسبت قیمت', 'بهترین کیفیت، تطبیق پذیری و نسبت قیمت', 'Laser' );
pll_register_string( 'هزینه کاهش یافته ی نگهداری', 'هزینه کاهش یافته ی نگهداری', 'Laser' );

/* Shears Page */
pll_register_string( 'گیوتین', 'گیوتین', 'Shears' );
pll_register_string( 'توضیح گیوتین', 'محصولات متنوع گیوتین برای گستره ی وسیعی از ضخامت ها و اندازه های ورق که تمامی نیازهای برش را برطرف می کنند. گیوتین های برش آونگی و برش عمودی، تک منظوره یا ترکیبی با حالت اتوماتیک برای بهبود عملکرد. محصولات به صورت زیر است: خط SM چند منظوره استاندارد، محصول GH Swing Cut همه کاره، GV برش عمودی با اندازه بزرگ', 'Shears' );
pll_register_string( 'SM Guimadira', 'SM Guimadira', 'Shears' );
pll_register_string( 'بهترین نسبت قیمت به کیفیت', 'بهترین نسبت قیمت به کیفیت', 'Shears' );
pll_register_string( '2 مدل: 6mm یا 13mm با 3 متر طول', '2 مدل: 6mm یا 13mm با 3 متر طول', 'Shears' );
pll_register_string( 'Swing Cut', 'Swing Cut', 'Shears' );
pll_register_string( 'به صورت دلخواه با سیستم پشتیبانی ورق نازک', 'به صورت دلخواه با سیستم پشتیبانی ورق نازک', 'Shears' );
pll_register_string( 'سهولت استفاده', 'سهولت استفاده', 'Shears' );
pll_register_string( 'راه حل اثبات شده', 'راه حل اثبات شده', 'Shears' );
pll_register_string( 'طراحی و تولید شده در اروپا', 'طراحی و تولید شده در اروپا', 'Shears' );
pll_register_string( 'استانداردهای کیفی بالا', 'استانداردهای کیفی بالا', 'Shears' );
pll_register_string( 'قیمت رقابتی', 'قیمت رقابتی', 'Shears' );

pll_register_string( 'GH همه کاره', 'GH همه کاره', 'Shears' );
pll_register_string( 'گستره ی وسیعی از پیکربندی ها', 'گستره ی وسیعی از پیکربندی ها', 'Shears' );
pll_register_string( 'ضخامت و اندازه های چندگانه', 'ضخامت و اندازه های چندگانه', 'Shears' );
pll_register_string( 'زاویه ثابت کوچک برای پوشش تمام ضخامت ها', 'زاویه ثابت کوچک برای پوشش تمام ضخامت ها', 'Shears' );
pll_register_string( 'استحکام و قابلیت اطمینان', 'استحکام و قابلیت اطمینان', 'Shears' );
pll_register_string( 'ثبت اختراع SCSC، سیستم پشتیبانی ورق ترکیبی', 'ثبت اختراع SCSC، سیستم پشتیبانی ورق ترکیبی', 'Shears' );
pll_register_string( 'تجربه ی اثبات شده', 'تجربه ی اثبات شده', 'Shears' );
pll_register_string( 'طیف وسیعی از انتخاب ها', 'طیف وسیعی از انتخاب ها', 'Shears' );

pll_register_string( 'GV مخصوص کارهای سنگین', 'GV مخصوص کارهای سنگین', 'Shears' );
pll_register_string( 'گیوتینی برای ابعاد بزرگ', 'گیوتینی برای ابعاد بزرگ', 'Shears' );
pll_register_string( 'ضخامت برش حداکثر تا 25mm، در صورت نیاز گزینه های سفارشی بیشتری وجود داردمصرف الکتریکی پایین', 'ضخامت برش حداکثر تا 25mm، در صورت نیاز گزینه های سفارشی بیشتری وجود داردمصرف الکتریکی پایین', 'Shears' );
pll_register_string( 'اندازه حداکثر تا 6 متر، در صورت نیاز گزینه های سفارشی بیشتری وجود دارد', 'اندازه حداکثر تا 6 متر، در صورت نیاز گزینه های سفارشی بیشتری وجود دارد', 'Shears' );
pll_register_string( 'برش عمودی', 'برش عمودی', 'Shears' );
pll_register_string( 'سیستم ضد پیچش انتخابی', 'سیستم ضد پیچش انتخابی', 'Shears' );
pll_register_string( 'استحکام، قابلیت اطمینان، ایمنی', 'استحکام، قابلیت اطمینان، ایمنی', 'Shears' );
pll_register_string( 'انتخاب ایده آل برای وظایف سنگین', 'انتخاب ایده آل برای وظایف سنگین', 'Shears' );

/* Hexa-C Page */
pll_register_string( 'Hexa-C', 'Hexa-C', 'HexaC' );
pll_register_string( 'Hexa-C  حلقه گمشده خمکاری دقیق!', 'Hexa-C  حلقه گمشده خمکاری دقیق!', 'HexaC' );
pll_register_string( 'Adira Hexa-C Patent', 'Adira Hexa-C Patent', 'HexaC' );
pll_register_string( 'Frame deflection', 'Frame deflection', 'HexaC' );
pll_register_string( 'Hexa-C Frame', 'Hexa-C Frame', 'HexaC' );
pll_register_string( 'Old Frame', 'Old Frame', 'HexaC' );
pll_register_string( ' مقایسه خمکاری با سیستم قدیمی و سیستم جدید', ' مقایسه خمکاری با سیستم قدیمی و سیستم جدید', 'HexaC' );
pll_register_string( 'کاهش انحراف زاویه ای از 2 به 0.5 درجه!', 'کاهش انحراف زاویه ای از 2 به 0.5 درجه!', 'HexaC' );
pll_register_string( 'تفاوت استفاده و عدم استفاده از Hexa-C  در انحراف زاویه ای!', 'تفاوت استفاده و عدم استفاده از Hexa-C  در انحراف زاویه ای!', 'HexaC' );
pll_register_string( 'مزایای استفاده از Hexa-C', 'مزایای استفاده از Hexa-C', 'HexaC' );
pll_register_string( 'پرس بریک های  C فریم از دو طرف فریم کناری ( هوزینگ) و قسمت پایینی و تکیه گاههای اتصالی تشکیل شده است. و سیلندرهای فشار و بیم بالا رویه قسمت بالایی بدنه سوار می شوند.', 'پرس بریک های  C فریم از دو طرف فریم کناری ( هوزینگ) و قسمت پایینی و تکیه گاههای اتصالی تشکیل شده است. و سیلندرهای فشار و بیم بالا رویه قسمت بالایی بدنه سوار می شوند.', 'HexaC', true );
pll_register_string( 'به خاطر این فریم C  شکل، هنگام خمکاری علی رغم استحکام و تقویت بدنه، همواره خمشی به سمت عقب در بدنه اتفاق می افتد ( تصویر بالا) که در نتیجه آن ابزار بر روی  بیم بالا از مرکز ابزار در بیم پایین که ثابت است خارج می شود.', 'به خاطر این فریم C  شکل، هنگام خمکاری علی رغم استحکام و تقویت بدنه، همواره خمشی به سمت عقب در بدنه اتفاق می افتد ( تصویر بالا) که در نتیجه آن ابزار بر روی  بیم بالا از مرکز ابزار در بیم پایین که ثابت است خارج می شود.', 'HexaC', true );
pll_register_string( 'در تئوری، جکهای دو طرف بصورت کاملا سینکرونایز می بایست عمل کنند ؛ با این وجود در عمل اینطور نیست و تناژ مورد نیاز درهرجک تحت تاثیر عواملی همچون: تغییر آنالیز ورق در طول خم، تغییر سختی در طول خم،وجود سوراخ در قسمتی از خم و نیز تغییر ضخامت جزیی در طول خم و عواملی از این دست، سبب تغییر تناژ در دو سر خم می شود.', 'در تئوری، جکهای دو طرف بصورت کاملا سینکرونایز می بایست عمل کنند ؛ با این وجود در عمل اینطور نیست و تناژ مورد نیاز درهرجک تحت تاثیر عواملی همچون: تغییر آنالیز ورق در طول خم، تغییر سختی در طول خم،وجود سوراخ در قسمتی از خم و نیز تغییر ضخامت جزیی در طول خم و عواملی از این دست، سبب تغییر تناژ در دو سر خم می شود.', 'HexaC', true );
pll_register_string( 'این تغییر تناژ در دو سر خمکاری، سبب تغییر مقدار خمش در بدنه دستگاه می شود و این مقدار خمش تحت تاثیر عوامل گفته شده در بالا در هر بار خمکاری متفاوت خواهد بود و در نتیجه آن، مقدار نیروی وارد شده به خم در هر بار خمکاری متفاوت شده، به این ترتیب در صورت عدم کنترل این خمش، زاویه خم در دو سر خمکاری یکسان نخواهد بود و نیز تکرار پذیری وجود ندارد.', 'این تغییر تناژ در دو سر خمکاری، سبب تغییر مقدار خمش در بدنه دستگاه می شود و این مقدار خمش تحت تاثیر عوامل گفته شده در بالا در هر بار خمکاری متفاوت خواهد بود و در نتیجه آن، مقدار نیروی وارد شده به خم در هر بار خمکاری متفاوت شده، به این ترتیب در صورت عدم کنترل این خمش، زاویه خم در دو سر خمکاری یکسان نخواهد بود و نیز تکرار پذیری وجود ندارد.', 'HexaC', true );
pll_register_string( 'بنابر این در صورتی که یک خم با کیفیت و با زوایای یکسان در دو سر میخواهید تولید کنید، اثر خمش بدنه کنترل و یا جبران شود.', 'بنابر این در صورتی که یک خم با کیفیت و با زوایای یکسان در دو سر میخواهید تولید کنید، اثر خمش بدنه کنترل و یا جبران شود.', 'HexaC', true );
pll_register_string( 'برخی ماشین های گران قیمت از تجهیزاتی برای خواندن مقدار این خمش و در نهایت محاسبه مقدار نیروی جبران در کنترلر استفاده می کنند که این روش بسیار گران قیمت می شود و ماشینهای این چنینی ماشینهایی با قیمت بالا هستند.', 'برخی ماشین های گران قیمت از تجهیزاتی برای خواندن مقدار این خمش و در نهایت محاسبه مقدار نیروی جبران در کنترلر استفاده می کنند که این روش بسیار گران قیمت می شود و ماشینهای این چنینی ماشینهایی با قیمت بالا هستند.', 'HexaC', true );
pll_register_string( 'شرکت Adira  با نوآوری توانسته با اجرای مکانیزمی بسیار کارا و دقیق و تغییر طراحی بدنه، بطور کلی اثر خمش بدنه را در خمکاری کنترل کند و با یک روش ارزان و کاملا دقیق توانسته ماشینهای ارزان قیمت تر ولی با دقت و کیفیت ماشینهای گران قیمت بسازد.', 'شرکت Adira  با نوآوری توانسته با اجرای مکانیزمی بسیار کارا و دقیق و تغییر طراحی بدنه، بطور کلی اثر خمش بدنه را در خمکاری کنترل کند و با یک روش ارزان و کاملا دقیق توانسته ماشینهای ارزان قیمت تر ولی با دقت و کیفیت ماشینهای گران قیمت بسازد.', 'HexaC', true );
pll_register_string( 'Hexa-C  نوآوری شرکت Adira  و Patent  این شرکت می باشد که تحولی عظیم در صنعت خمکاری ایجاد نموده است.', 'Hexa-C  نوآوری شرکت Adira  و Patent  این شرکت می باشد که تحولی عظیم در صنعت خمکاری ایجاد نموده است.', 'HexaC', true );
pll_register_string( 'با Hexa-C حرکت بیم بالا از بدنه جدا شده و با وجود خمشهای متفاوت در بدنه ، مسیر حرکت بیم بالا درون یک ریل محور Y محدود شده است. به این ترتیب ابزار بالا همواره در راستای ابزار پایین خواهد بود.', 'با Hexa-C حرکت بیم بالا از بدنه جدا شده و با وجود خمشهای متفاوت در بدنه ، مسیر حرکت بیم بالا درون یک ریل محور Y محدود شده است. به این ترتیب ابزار بالا همواره در راستای ابزار پایین خواهد بود.', 'HexaC', true );
pll_register_string( 'افزایش کیفیت و دقت خمکاری و تولید خمهایی یکسان و تکرار پذیر با حذف انحراف زاویه ای، بدست آمدن خمهایی بازوایای یکسان در دو سر و وسط هم', 'افزایش کیفیت و دقت خمکاری و تولید خمهایی یکسان و تکرار پذیر با حذف انحراف زاویه ای، بدست آمدن خمهایی بازوایای یکسان در دو سر و وسط هم', 'HexaC', true );
pll_register_string( 'افزایش بازدهی و افزایش تولید به واسطه تکرار پذیری بالا و کاهش زمان ست آپ', 'افزایش بازدهی و افزایش تولید به واسطه تکرار پذیری بالا و کاهش زمان ست آپ', 'HexaC', true );
pll_register_string( 'کاهش استهلاک ماشین : همراستایی ابزار بالا و پایین باعث می شود با تناژ کمتری خم مورد نظر بدست بیاید', 'کاهش استهلاک ماشین : همراستایی ابزار بالا و پایین باعث می شود با تناژ کمتری خم مورد نظر بدست بیاید', 'HexaC', true );
pll_register_string( 'کاهش استهلاک ابزار بواسطه همراستایی با ابزار پایین', 'کاهش استهلاک ابزار بواسطه همراستایی با ابزار پایین', 'HexaC', true );
pll_register_string( 'کاهش استهلاک ابزار بواسطه همراستایی با ابزار پایین', 'کاهش استهلاک ابزار بواسطه همراستایی با ابزار پایین', 'HexaC', true );

/* Training Page */
pll_register_string( 'مشاوره و آموزش', 'مشاوره و آموزش', 'Training' );
pll_register_string('ما روی خدمات به شما،شنیدن موضوعات و چالشهای شما متمرکز هستیم و به دنبال برآورده کردن این موضوعات  با دانش،تجربه و خدمات ، منابع و عملکردی با کیفیت هستیم. با توجه به گسترش روز افزون تکنولوژی و استفاده از آن در صنایع مختلف، پیچیدگی ماشین آلات و تنوع کاربریهای آنها، رسیدن به بالاترین سطح بهره وری و کارایی تنها با آموزش اپراتوری امکان پذیر نخواهد بود.', 'ما روی خدمات به شما،شنیدن موضوعات و چالشهای شما متمرکز هستیم و به دنبال برآورده کردن این موضوعات  با دانش،تجربه و خدمات ، منابع و عملکردی با کیفیت هستیم. با توجه به گسترش روز افزون تکنولوژی و استفاده از آن در صنایع مختلف، پیچیدگی ماشین آلات و تنوع کاربریهای آنها، رسیدن به بالاترین سطح بهره وری و کارایی تنها با آموزش اپراتوری امکان پذیر نخواهد بود.', 'Training', true);
pll_register_string('تجربه و بررسی کارخانه های مختلف تولیدی نشان دهنده این موضوع است که سخت افزارها (ماشین آلات) بدون داشتن سه عامل کلیدی  1-فرایند درست 2- نرم افزار های قوی و به روز و 3- نهایتا تیم آموزش دیده ، هیچ زمان به حداکثر بازدهی نمی رسند ،نیل به چنین اهدافی نیازمند، شناخت کامل ماشین و قابلیتهای آن، شناخت و تسلط کامل بر نرم افزار و نهایتا شناخت فرایندها و استراتژیهای مختلف تولید در ورق کاری است و بازگشت سرمایه شما تنها و تنها در گرو آن است که با تحولاتی در سیستم ورقکاری بتوانید پتانسیلهای سخت افزاری را به فعل در آورید.', 'تجربه و بررسی کارخانه های مختلف تولیدی نشان دهنده این موضوع است که سخت افزارها (ماشین آلات) بدون داشتن سه عامل کلیدی  1-فرایند درست 2- نرم افزار های قوی و به روز و 3- نهایتا تیم آموزش دیده ، هیچ زمان به حداکثر بازدهی نمی رسند ،نیل به چنین اهدافی نیازمند، شناخت کامل ماشین و قابلیتهای آن، شناخت و تسلط کامل بر نرم افزار و نهایتا شناخت فرایندها و استراتژیهای مختلف تولید در ورق کاری است و بازگشت سرمایه شما تنها و تنها در گرو آن است که با تحولاتی در سیستم ورقکاری بتوانید پتانسیلهای سخت افزاری را به فعل در آورید.', 'Training', true);
pll_register_string('بازدیدهای بسیار و مشاهده روشهای مختلف تولید از کارخانجات کوچک و بزرگ در صنایع مختلف آشکار نموده است که برخی سیستمها سالهاست که بدون کوچکترین تغییری برقرار است و هیچگاه روشهای مورد استفاده به لحاظ کارایی و اثربخشی مورد بازبینی قرار نگرفته اند در حالیکه بر افزایش تعداد ماشین آلات و تعداد نفرات جهت افزایش تولید اصرار وجود دارد ،کمتر به تغییرات سیستمی برای رسیدن به این اهداف پرداخته شده است.', 'بازدیدهای بسیار و مشاهده روشهای مختلف تولید از کارخانجات کوچک و بزرگ در صنایع مختلف آشکار نموده است که برخی سیستمها سالهاست که بدون کوچکترین تغییری برقرار است و هیچگاه روشهای مورد استفاده به لحاظ کارایی و اثربخشی مورد بازبینی قرار نگرفته اند در حالیکه بر افزایش تعداد ماشین آلات و تعداد نفرات جهت افزایش تولید اصرار وجود دارد ،کمتر به تغییرات سیستمی برای رسیدن به این اهداف پرداخته شده است.', 'Training', true);
pll_register_string('سیستم های موجود کارایی لازم را ندارند چرا که بیشتر به آموزش اپراتوری ماشین اهمیت داده شده است تا بهترین روش و فرایند استفاده از ماشین جهت بیشترین و بهینه ترین تولید!', 'سیستم های موجود کارایی لازم را ندارند چرا که بیشتر به آموزش اپراتوری ماشین اهمیت داده شده است تا بهترین روش و فرایند استفاده از ماشین جهت بیشترین و بهینه ترین تولید!', 'Training', true);
pll_register_string('به این دلیل که ماشین خوبی داریم، نمیتوانیم مطمئن باشیم تولید مقرون به صرفه ای هم داریم، سیستمهای بسیاری بدون در نظر گرفتن بهای تمام شده مشغول کارند، به عنوان مثال آیا می دانید قیمت هر ضربه یک ماشین پانچ چقدر است؟ چرا فکر می کنیم استفاده از گیوتین در مقابل پانچ مقرون به صرفه تر است؟ آیا گلوگاههای خود ساخته را باید همچنان حفظ کنیم؟', 'به این دلیل که ماشین خوبی داریم، نمیتوانیم مطمئن باشیم تولید مقرون به صرفه ای هم داریم، سیستمهای بسیاری بدون در نظر گرفتن بهای تمام شده مشغول کارند، به عنوان مثال آیا می دانید قیمت هر ضربه یک ماشین پانچ چقدر است؟ چرا فکر می کنیم استفاده از گیوتین در مقابل پانچ مقرون به صرفه تر است؟ آیا گلوگاههای خود ساخته را باید همچنان حفظ کنیم؟', 'Training', true);
pll_register_string('کاملا روشن است که هر تولید کننده ای به تمامی موارد بالا می اندیشد و دغدغه همیشگی شما به عنوان تولید کننده  می باشد. با این وجود رسیدن به این اهداف نیازمند امکانات و شرایط و البته اراده می باشد.', 'کاملا روشن است که هر تولید کننده ای به تمامی موارد بالا می اندیشد و دغدغه همیشگی شما به عنوان تولید کننده  می باشد. با این وجود رسیدن به این اهداف نیازمند امکانات و شرایط و البته اراده می باشد.', 'Training', true);
pll_register_string('در هرصورت بازگشت سرمایه ، تولید مقرون به صرفه و پیش افتادن از رقبایی که در سکوت در حال پیشروی هستند نیاز امروز هر سازمانی است.', 'در هرصورت بازگشت سرمایه ، تولید مقرون به صرفه و پیش افتادن از رقبایی که در سکوت در حال پیشروی هستند نیاز امروز هر سازمانی است.', 'Training', true);
pll_register_string('تیم مهندسی این شرکت با تجربه و دانش خود توانسته پیش از این منشا تغییرات بسیاری در جهت بهبود شرایط تولید کارخانجات کوچک و بزرگ باشد.', 'تیم مهندسی این شرکت با تجربه و دانش خود توانسته پیش از این منشا تغییرات بسیاری در جهت بهبود شرایط تولید کارخانجات کوچک و بزرگ باشد.', 'Training', true);
pll_register_string('شرکت راتین تجهیز البرز با بهره گیری از شرکای تجاری خود تلاش نموده است تا ضمن افزایش دانش تیم فنی خود، ضمن مشاوره و آموزش شرکتهای مختلف، گامی در جهت تولید با بهره وری بالاتر و مقرون به صرفه تر بردارد.', 'شرکت راتین تجهیز البرز با بهره گیری از شرکای تجاری خود تلاش نموده است تا ضمن افزایش دانش تیم فنی خود، ضمن مشاوره و آموزش شرکتهای مختلف، گامی در جهت تولید با بهره وری بالاتر و مقرون به صرفه تر بردارد.', 'Training', true);
pll_register_string('در حال حاضر خدمات شرکت به شرح زیر می باشد:', 'در حال حاضر خدمات شرکت به شرح زیر می باشد:', 'Training');
pll_register_string('مشاوره در تامین ماشین آلات', 'مشاوره در تامین ماشین آلات', 'Training');
pll_register_string('تجزیه و تحلیل و بهینه سازی فرایندهای تولید', 'تجزیه و تحلیل و بهینه سازی فرایندهای تولید', 'Training');
pll_register_string('آموزش پانچ و خم و لیزر', 'آموزش پانچ و خم و لیزر', 'Training');
pll_register_string('آشنایی با تجهیز و نگهداری ابزارهای پانچ و پرس برک', 'آشنایی با تجهیز و نگهداری ابزارهای پانچ و پرس برک', 'Training');
pll_register_string('آموزش کامل نرم افزار پانچ و برش Lantek Cad/cam', 'آموزش کامل نرم افزار پانچ و برش Lantek Cad/cam', 'Training');
pll_register_string('ما میخواهیم عمیق ترین اعتماد شما را بدست آوریم و معتقدیم بهتر امکان پذیر است.', 'ما میخواهیم عمیق ترین اعتماد شما را بدست آوریم و معتقدیم بهتر امکان پذیر است.', 'Training');

