<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WP_Bootstrap_Starter
 */

?>
<?php if(!is_page_template( 'blank-page.php' ) && !is_page_template( 'blank-page-with-container.php' )): ?>
    <div class="contact form-linear bg-blue container-fluid pt-5 pb-5">
        <div class="row title mb-2">
            <div class="col-sm-12">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="animation-slide-up">
                            <h1 class="text-center font-weight-bold text-nowrap"><?php pll_e('ارتباط با ما'); ?></h1>
                        </div>
                        <i class="fa fa-envelope position-absolute bg bg-center text-white" aria-hidden="true" style="top:-65px; z-index: 0;"></i>
                    </div>
                    <div class="col-md-6 offset-md-3 col-sm-8 offset-sm-2 col-12 offset-0 position-relative">
                        <div class="d-flex flex-row justify-content-center align-items-center">
                            <hr class="border-white" style="width: 45%; opacity: .5;">
                            <i class="fa fa-angle-double-down fa-2x text-center text-white angle" aria-hidden="true"></i>
                            <hr class="border-white" style="width: 45%; opacity: .5;">
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <form id="contactForm" novalidate autocomplete="off">
            <div class="form-row py-5">
                <div class="form-group col-lg-6 col-12 px-md-5 px-3 mb-0">
                    <div class="form-group row">
                        <div class="col-sm-12">
                            <input type="text" name="name" id="name" class="form-control" placeholder="<?php pll_e('نام شما:'); ?>" value="">
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-sm-12">
                            <input type="text" name="email" id="email" class="form-control" placeholder="<?php pll_e('ایمیل شما:'); ?>" value="">
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-sm-12">
                            <input type="text" name="phone" id="phone" class="form-control" placeholder="<?php pll_e('تلفن شما:'); ?>" value="">
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-sm-12">
                            <input type="text" name="postalCode" id="postalCode" class="form-control" placeholder="<?php pll_e('کد پستی:'); ?>" value="">
                        </div>
                    </div>
                </div>
                <div class="form-group col-lg-6 col-12 px-md-5 px-3 mb-0">
                    <div class="form-group row">
                        <div class="col-sm-12">
                            <input type="text" name="companyName" id="companyName" class="form-control" placeholder="<?php pll_e('نام شرکت شما:'); ?>" value="">
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-sm-12">
                            <textarea class="form-control" name="comment" id="comment" placeholder="<?php pll_e('پیام شما:'); ?>" style="height: 9rem;"></textarea>
                        </div>
                    </div>
                </div>
            </div>
            <div class="form-row justify-content-center pb-3">
                <div class="g-recaptcha" data-sitekey="6LfR9UcUAAAAAHX-CxiRHeJRSX_ISZpK1jXygGwL" data-theme="dark"></div>
            </div>
            <div class="form-row">
                <div class="form-group col-sm-12 text-center">
                    <button type="submit" class="btn btn-primary btn-special btn-lg"><?php pll_e('ارسال پیام'); ?></button>
                    <input type="hidden" name="submitted" id="submitted" value="1" />
                </div>
            </div>
            <div class="form-row justify-content-center">
                <div id="contact-us-status" class="alert" role="alert"></div>
            </div>
        </form>
        <script>
            (function() {
                'use strict';

                window.addEventListener('load', function() {
                    var form = document.getElementById('needs-validation');
                    form.addEventListener('submit', function(event) {
                        if (form.checkValidity() === false) {
                            event.preventDefault();
                            event.stopPropagation();
                        }
                        form.classList.add('was-validated');
                    }, false);
                }, false);
            })();
        </script>
    </div>
    <footer role="contentinfo">
        <div class="container-fluid px-sm-5 px-3 pb-3 pt-5">
            <div class="row">
                <div class="col-12">
                    <small><span class="font-weight-bold"><?php pll_e('آدرس:'); ?></span> <?php pll_e('تهران- ظفر(شریعتی)-بعدازتبریزیان-پلاک83-طبقه5 واحد29 '); ?></small>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-3 col-md-4 col-sm-6 col-12">
                    <small><span class="font-weight-bold"><?php pll_e('تلفن:'); ?></span><span class="px-2" dir="ltr">+98 21 88764110</span><span class="px-2" dir="ltr">+98 21 88766904</span></small>
                </div>
                <div class="col-lg-3 col-md-4 col-sm-6 col-12">
                    <small><span class="font-weight-bold"><?php pll_e('فکس:'); ?></span><span class="px-2" dir="ltr">+98 21 22912592</span></small>
                </div>
            </div>
            <hr>
            <div class="row" dir="rtl">
                <div class="col-lg-6 text-lg-right text-center social">
                    <a class="mx-2 text-center" href="https://www.linkedin.com/in/ratin-tajhiz-alborz-94176869" target="_blank">
                        <img src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/social_network/linkedin.png">
                    </a>
                    <a class="mx-2 text-center" href="https://www.instagram.com/ratintajhiz" target="_blank">
                        <img src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/social_network/instagram.png">
                    </a>
                    <a class="mx-2 text-center" href="http://T.me/ratintajhiz" target="_blank">
                        <img src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/social_network/telegram.png">
                    </a>
                    <a class="mx-2 text-center" href="https://www.aparat.com/ratintajhiz" target="_blank">
                        <img src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/social_network/aparat.png" style="width: 26px; height: 26px;">
                    </a>
                </div>
                <div class="col-lg-6 text-lg-left text-center" dir="ltr">
                    <small><a href="<?php echo esc_url( home_url( "/" )); ?>">Ratin Tajhiz</a> © <?php echo date('Y'); ?> All Rights Reserved. Design by <a href="http://www.webijad.com/" target="_blank">Webijad</a></small>
                </div>
            </div>
        </div>
    </footer>
<?php endif; ?>

<?php wp_footer(); ?>
<div class="social-fix fixed-top d-none d-md-flex flex-column">
    <a class="text-center d-flex align-items-center justify-content-center" href="https://www.linkedin.com/in/ratin-tajhiz-alborz-94176869" target="_blank">
        <img src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/social_network/linkedin.png">
    </a>
    <a class="text-center d-flex align-items-center justify-content-center" href="https://www.instagram.com/ratintajhiz" target="_blank">
        <img src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/social_network/instagram.png">
    </a>
    <a class="text-center d-flex align-items-center justify-content-center" href="http://T.me/ratintajhiz" target="_blank">
        <img src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/social_network/telegram.png">
    </a>
    <a class="text-center d-flex align-items-center justify-content-center" href="https://www.aparat.com/ratintajhiz" target="_blank">
        <img src="<?php echo get_template_directory_uri(); ?>/inc/assets/img/social_network/aparat_w.png" style="width: 26px; height: 26px;">
    </a>
</div>
</body>
</html>
